# 全球时间跳跃

**全球时间跳跃**是让玩家的挂机剩余时间立即缩短的游戏功能。当一名玩家启动全球时间跳跃，效果将及于在此之前已开始进行挂机作业的所有玩家。正在进行挂机作业的玩家会被排入一个加速队列，逐一对玩家进行加速。通常会需要 1 ~ 3 分钟的时间，才会将所有玩家加速完毕（队列愈长，所需时间愈久）。

![GlobalSkip](/resources/mobile-tutorial/GlobalSkip.png)

若要启动全球时间跳跃，玩家须取得名为「Unit」的特殊货币，这种货币只能通过使用真实货币购买。全球时间跳跃的价格取决于其缩减的时间长短，每多缩减 15 分钟将额外花费 64 Units（例如：若要启动 30 分钟的全球时间跳跃，玩家将花费 128 Units）。

![GlobalSkip2](/resources/mobile-tutorial/GlobalSkip2.png)

玩家最多可以通过全球时间跳跃一次缩减 8 小时的挂机作业时间，这将花费 2048 Units。建议多次全球时间跳跃之间至少间隔 1 分钟，让其他玩家有时间进行挂机作业以获得全球时间跳跃的加成。

## 全球时间跳跃的效益最大化

玩家可以启动进行全球时间跳跃，但建议玩家在特定的**加速器 / 全球增益**的启用期间使用全球时间跳跃，这样会让全球时间跳跃的效益更高。一般而言，建议搭配的全球增益如下：

### 神经突触加速器

![GlobalBuff_AFK](/resources/mobile-tutorial/GlobalBuff_AFK.png)

这个道具将在 10 分钟内使挂机作业加速 5%，最多叠加至 80%。玩家只要每次使用一个加速器，就能重置增益计时器以延长增益时间。要利用这个增益，玩家必须在增益期间内开始挂机作业。这个道具的增益效果是全球的，而且和「稀有神经突触加速器」的效果不会相互叠加。玩家只能通过地下城或玩家间的交易获得这件道具。

### 稀有神经突触加速器

![GlobalBuff_AFK2](/resources/mobile-tutorial/GlobalBuff_AFK2.png)

这件道具与普通的**神经突触加速器**相似，但彼此效果不能相互叠加。稀有加速器将在 20 分钟内使挂机作业加速 40%，最多叠加至 80%。玩家只要每次使用一个稀有加速器，就能重置增益计时器以延长增益时间。要利用这个增益，玩家必须在增益期间内开始挂机作业。玩家只能通过荒坂货币兑换获得这件道具。

### 交易漏洞发信器

![GlobalBuff_BTC](/resources/mobile-tutorial/GlobalBuff_BTC.png)

**交易漏洞发信器**用于增加比特币的获得数量，运作方式与加速器相似，其效果可以叠加，且重复使用可以延长增益时间。交易漏洞发信器将在 20 分钟内使比特币获得数量增加 40%，最多叠加至 100%。

### 额叶皮质优化器

![GlobalBuff_EXP](/resources/mobile-tutorial/GlobalBuff_EXP.png)

**额叶皮质优化器**用于增加经验值获得量。额叶皮质优化器将在 20 分钟内使经验值获得量增加 80%，最多叠加至 100%。

为了将效益最大化，建议玩家同时购买**稀有神经突触加速器**，并在全球时间跳跃启动之前同时使用这两件道具。如此一来，玩家可以完成更多的挂机作业。

以下是一个简单的应用实例：

- 若一名玩家为了单一挂机作业启用了 2 小时 / 120 分钟的全球时间跳跃，他将花费 **512 Units**。
- 若一名玩家同时使用稀有神经突触加速器（花费 64 Units x 2），2 小时的挂机作业将缩短为 24 分钟，因此仅需要 30 分钟的全球时间跳跃（花费 128 Units）即能完成挂机作业。如此一来，总花费仅需要 **256 Units**（剩余的 256 Units 还可以购买两次 30 分钟的全球时间跳跃）。

你也可以同时使用其他全球增益（像是交易漏洞发信器或额叶皮质优化器），所有玩家都能享受这些增益。

## 向时间跳跃者致敬

全球时间跳跃启用时，游戏中会通过系统讯息，在聊天室公告启用这个效果的时间跳跃者是谁。这个系统讯息将载明本次时间跳跃的持续期间、以及队列的总人数。

![SkipperRespect](/resources/mobile-tutorial/SkipperRespect.png)

当全球时间跳跃启用之后，一个独特的按钮（外观为两个三角形构成的快转键）会出现在聊天室右侧，位于「发送」按钮的上方。这个快转键又称为**时间跳跃者致敬**键。这个按钮只会在全球时间跳跃期间出现，于全球时间跳跃结束后就会消失。

![SkipperRespect2](/resources/mobile-tutorial/SkipperRespect2.png)

每当玩家点击这个按钮（会出现彩色的心型 / 雪花特效），玩家将有一定机率获得奖励。奖励的内容包括医疗科技零件、AI 核心、背包、甚至史诗装备等。这个活动称为**时间跳跃者摸奖**。

有时候，心型 / 雪花特效可能会导致游戏延迟（取决于玩家的行动装置的规格），造成不佳的游戏体验。玩家可以通过点在地图或个人档案页面中，点击手机形状的选单并选择设置页面，并选择停用这些特效（这将使该名玩家无法参与时间跳跃者摸奖）。