# Resources
Every item has it's own purposes, ranging from ranging from **Equipment** (which also includes **Upgrade Modules** and **Equipment Caches**), **Ammo**, **Medical Items**, **Crafting Ingredients**, **Key Fragment / Secret Keys**, **Global Boost**, and other consumables. Here are some items that are catalogued onto it's respective category.


## Ammo (for weapons)

### Energy Cells  
Your **Special Weapon** uses **Energy Cells**. You can find Energy Cells as drops after winning fights or by crafting them using Ammunition Tech Parts. You can carry a maximum of 10000 Energy Cells at a time.

### Anti Matter Charge 
Your **Destructive Weapon** uses **Anti Matter Charge**. You can find them as drops (less often than Energy Cells) or by crafting them from Military Ammunition Tech Parts. You can carry a maximum of 10000 Antimatter Charges at a time.


## Equipment

### Gears / Upgrade Module
On your inventory, both **Equipment** and **Upgrade Module** were treated as a unique item thus it takes one inventory space per item (even with a same item name / rarity / quality). At this point, it's recommended to put your unused gear onto Bank Storage. Selling or scrapping unused gear were also an option to conserve inventory space.

You can choose when to equip a gear by choosing the **Equip** button. Equipped gear will be highlighted at the top of the inventory page. By clicking on gears, you can also choose to install upgrade modules that will enhance certain values of that item. To remove installed upgrade modules, simply click on the installed module. Better rarity & quality equipment will have more upgrade slots.

You can get both Gear and Upgrade Module as a boss / crate drops in Dungeon, via printing in **Molecular 3D Printer**, as a **Daily Rewards**, or by buying one on either NPC Market (**Weapon Smith**) or Players Market (**Shangri-La Market Street**).  

### Equipment Caches
On your Inventory, all **Equipment Caches** were grouped based on their rarity and types of caches. You can stock as many caches as you want with a maximum of 10000 items per type of cache.

In order to use (or which we'll refer to as "Print" later on) one, a player must visit **Molecular 3D Printer** which can be found in **Shangri-La City Center**. Not only that, a player must have their BTC on its character in order to print one. The price of printing equipment caches was ranged based on both rarity and Printing Skills level.

You can get both Equipment as a boss / crate drops in Dungeon, via **Deploy Farm Bot** task, or by buying one on Players Market (**Shangri-La Market Street**). 


## Tech Parts
Tech Parts are an item ingredient to craft corresponding items via Crafting tab that's located in your Inventory menu. Tech Parts can be used for other dedicated tasks or even converted into other types of tech scrap.

### Ammunition Tech Parts
One of the item ingredients to craft **Energy Cells** and **Military Ammunition Tech Parts**.

Other Ammunition Tech Parts usage is as follows:
- Can be recycled to yield Tech Scrap (which can be done in **Gang Headquarters**)
- Tradeable items that players can buy / sell to other players via **Player Trade**

### Military Ammunition Tech Parts
One of the item ingredients to craft **Anti Matter Charge** and **Hash Processor**.

Other Military Ammunition Tech Parts usage is as follows:
- Can be recycled to yield Tech Scrap (which can be done in **Gang Headquarters**)
- Tradeable items that players can buy / sell to other players via **Player Trade**

### Medical Tech Parts
One of the item ingredients to craft **Healing Items** and **Hash Processor**.

Other Medical Tech Parts usage is as follows:
- Can be recycled to yield Tech Scrap (which can be done in **Gang Headquarters**)
- Tradeable items that players can buy / sell to other players via **Player Trade**

### Tech Scrap
One of the item ingredients to craft **Drone Healing** items, Hash Processor, and AI Core. 

Other Tech Scrap usage is as follows:
- Initialize **Reverse Engineering** task (which can be found in **Shangri-La Commercial Area**)
- An item / requirements to open Locked Container (which can be found in **Terminal**)
- An item / requirements to trade Backpack (which can be done in **Lee's Trade Post**)
- Tradeable items that players can buy / sell to other players via **Player Trade**


## Medical / Healing Items
Players can use **Medical Tech Parts** and **Tech Scrap** to craft medicine for use in dungeons. In order to craft better medicine, players need to improve their medical science levels which can be done by performing the associated job training or by crafting medicine. Furthermore, better medicine requires players to use more Medical Tech Parts. For example, the lowest level medicine that can be crafted is the Pain Away for 1 Medical Tech Part while the Degraded Nano Repair Bot needs 2 Medical Tech Parts and a medical science level of 10.  
  
There are two categories of medicine that can be crafted which are **Single Heals** and **Group Heals**. Further information as follows:

### Single Heals  
As the name suggests, single heals will only heal yourself for the specified amount. Single heal medicines are items such as Pain Away and anything ending with Bot (e.g. Nano Medic Bot). In order to craft single heals, you need the specified medical science level and Medical Tech Parts.  

In general, the healing item / heal amount / medical level requirement / med tech amount as follows:

> **Pain Away** (501+ Health) - No Level ; 1 Med Tech

> **Degraded Nano Repair Bot** (1201+ Health) - Med Science 10 ; 2 Med Tech

> **Degraded Nano Medic Bot** (6001+ Health) - Med Science 20 ; 4 Med Tech

> **Nano Medic Bot** (12001+ Health) - Med Science 30 ; 8 Med Tech

> **Military Nano Medic Bot** (26001+ Health) - Med Science 40 ; 16 Med Tech

> **Advanced Nano Medic Bot**  (54001+ Health) - Med Science 50 ; 32 Med Tech

> **High Quality Nano Medic Bot** (110001+ Health)- Med Science 70 ; 64 Med Tech

> **Rare Nano Medic Bot** (240001+ Health) - Med Science 90 ; 128 Med Tech

> **Legendary Nano Medic Bot** (480001+ Health) - Med Science 110 ; 256 Med Tech

> **Epic Nano Medic Bot** (1000001+ Health) - Med Science 130 ; 256 Med Tech

### Group Heals  
Group heals can heal the entire group in a dungeon when used but will heal each person less than single heals of the same tier. Group heals are items such as Pain Away Spray and anything ending with Drone (e.g. Nano Medic Drone). In order to craft group heals, you need the same level single heal and the associated number of Tech Scrap. For instance, to make Pain Away Spray you need 1 Pain Away and 1 Tech Scrap. 

In general, the healing item / heal amount / medical level requirement / healing item & tech scrap amount as follows:

> **Pain Away Spray** (301+ Health) - Med Science 10 ; 1 Pain Away & 1 Tech Scrap

> **Degraded Repair Drone** (901+ Health) - Med Science 20 ; 1 Degraded Nano Repair Bot & 1 Tech Scrap

> **Degraded Nano Medic Drone** (4001+ Health) - Med Science 30 ; 1 Degreaded Nano Medic Bot & 1 Tech Scrap

> **Nano Medic Drone** (10001+ Health) - Med Science 40 ; 1 Nano Medic Bot & 1 Tech Scrap

> **Military Nano Medic Drone** (20001+ Health) - Med Science 50 ; 1 Military Nano Medic Bot & 1 Tech Scrap

> **Advanced Nano Medic Drone** (40001+ Health) - Med Science 60 ; 1 Advanced Nano Medic Bot & 1 Tech Scrap

> **High Quality Nano Medic Drone** (80001+ Health) - Med Science 80 ; 1 High Quality Nano Medic Bot & 1 Tech Scrap

> **Rare Nano Medic Drone** (160001+ Health) - Med Science 100 ; 1 Rare Nano Medic Bot & 1 Tech Scrap

> **Legendary Nano Medic Drone** (320001+ Health) - Med Science 120 ; 1 Legendary Nano Medic Bot & 1 Tech Scrap

> **Epic Nano Medic Drone** (640001+ Health) - Med Science 140 ; 1 Epic Nano Medic Bot & 1 Tech Scrap


## Consumables
These are an item that players can use for various needs, ranging from AFK Task, Market Item, Trade Item, or just a plain consumable.

### AI Core
**AI Cores** are essential for players as a way to gain Character EXP, a Market-value item, and Trade Currency. 

- For EXP purposes, players can use it on the highest unlocked area on Station via **Deploy Farm Bot** task. 
- For Market purposes, players can sell these items on **Shangri-La Market Street**, following current market prices. 
- For Trade purposes, players can trade their AI Cores for various items with other players such as Medical Tech Parts, Hash Processor, Containers, etc. 

### AI Core Cluster
**AI Core Cluster** is the compressed version of AI. 1 AI Core Cluster contains 1,000 AI, making it more managable and easy to store inside player's inventory. AI Core Cluster can be made (needs 1,000 AI & 50,000 BTC) and disassembled via Crafting.

AI Core Cluster can also be used as a Market-value item, and Trade Currency.

### Hash Processor
**Hash Processor** are essential for players as a way to gain Mining EXP, a Market-value item, and Trade Currency.  

- For EXP purposes, players can use it on **Shangri-La Commercial Area** via **Crypto Mining** task. 
- For Market purposes, players can sell these items on **Shangri-La Market Street**, following current market prices. 
- For Trade purposes, players can trade their Hash Processor for various items with other players such as Medical Tech Parts, AI Cores, Containers, etc. 

### Experience Memory / Shard
**Experience Memory / Shard** is an item that players can use to gain EXP instantly. The difference between Memory & Shard was the type of EXP, as Memory gains Character EXP and Shard gains Skills EXP respectively. These items are not tradable and best to be used when **Frontal Cortex Optimization Transmitter** or **EXP Buff** were in effect.

### Containers
**Containers** are essential for players as an alternative way of finding AI / Hash Processor, a Market-value item, and Trade Currency.  

To open Locked Containers, players must visit **Terminal** while having BTC and Tech Scrap in its inventory. When opening Containers, players will mostly find items such as AI Core, Hash Processor, Gear (based on players level), and unique drop which can only be found on specific Containers.

Players can also use Container as a Market item or as Trade Currency, which both benefits players via BTC or other traded items.

### Equipment Calibration Core
**Equipment Calibration Core** was used as a calibration item. Whenever a player attempts to do calibration, players must insert Equipment Calibration Core before proceeding to gear calibration. Explanation around Calibration can be found on [Calibration's Tutorial](https://cybercodeonline.com/markdown?path=tutorial%2Fcalibration.md)

Players can also use Equipment Calibration Core as a Market item or as Trade Currency, which both benefit players via BTC or other traded items.

### Factory Reset Shard
**Factory Shard** was used as a way to reset calibration, thus players can trade / sell the designated gear. Explanation around Calibration can be found on [Calibration's Tutorial](https://cybercodeonline.com/markdown?path=tutorial%2Fcalibration.md)

Players can also use Factory Shard as a Market item or as Trade Currency, which both benefit players via BTC or other traded items.


## Gang Items
These are an item that players can use for gang needs, ranging from AFK Task, Trade Item, or as a requirement to do a certain activity. For in-depth explanation around Gangs can be found on [Gang's Tutorial](https://cybercodeonline.com/markdown?path=tutorial%2Fgangs.md)

### Supply Crate
**Supply Crates** were used as a way to gain Gang Resources & Gang EXP. To do so, players must do Gang Task which involves using Supply Crates as a requirement (these certain tasks will also give players Mining EXP). Supply Crates can also be used as a way to "define gang territory" by doing **Occupation Control** task, as this will give the gang a certain **Occupation Point** with no contribution to Gang Resources.

Supply Crates are tradeable and can be sold or traded with other players.

### Encrypted Gang Memory Shard
**Encrypted Gang Memory Shard** was used as a way to gain Gang EXP. To do so, players must do Gang Task which involves using Encrypted Gang Memory Shard as a requirement (these certain tasks will also give players Mining EXP & Equipment Drops).

Encrypted Gang Memory Shard are tradeable and can be sold or traded with other players.

### Protocol Breach Shard
**Protocol Breach Shard** was used as a way to contribute to **SL-Data Fortress Breach** (which player can see its progression on **Quest** tab). To contribute to one, players must do Gang Task which involves using Protocol Breach Shard as a requirement.

Protocol Breach Shard are tradeable and can be sold or traded with other players.

### Gang Invasion Order Transmitter
**Gang Invasion Order Transmitter** was used as a way to enter **Gang Dungeons**. When entering one, keep in mind that Gang Dungeons are the most difficult dungeon of all, thus having proper gear might help ease out the difficulty.

Gang Invasion Order Transmitters are tradeable and can be sold or traded with other players.


## Boosts
While most **Boost** can be purchased in the **Arasaka Unit Exchange**, some of the boost below can only be found on specific places and cannot be bought on any store.

### Synaptic Acceleration Transmitter
This item will boost how quickly AFK time passes by +5% for 10 minutes, stackable up to +80%. You can use another to extend the duration of the boost, resetting the timer. To make use of the boost, you just need to begin an AFK session while the boost is active. This item is global and will affect and stack with other player. This does not stack with the rare version. This item can only be found on both **Dungeon's Boss Room crates** and **Pachinko**.

### Personal Calibration Shard
This item can only be used as a personal needs. It only affects for 5 minutes with a purpose of minimize the chance of calibration failure by 5% (or 50% if player stumble upon the **Personal Event** variation). The personal ones does not stack with the global ones. It stacks infinitely and not affected with other players.  This item can only be found on **Rare Container**. Explanation around Calibration can be found on [Calibration's Tutorial](https://cybercodeonline.com/markdown?path=tutorial%2Fcalibration.md)

### CyberTunnel VPN
This item will negates all chat exploits for 1 hour. It can only be used as a personal needs and not affected by other players. This item can be found on **Rare / Mysterious Container** and via Unit purchase on **Arasaka Unit Exchange**.


## Global Boosts
These items can only be purchased in the **Arasaka Unit Exchange**. The effects are global and will give everyone the benefits based on its buffs.

### Rare Synaptic Acceleration Transmitter
These are similar to regular Synaptic Acceleration Transmitters but don't stack with them. The rare version will instantly boost how quickly AFK time passes by +40% for 20 minutes, stackable to +80%. You can use another to extend the duration of the boost, thus resetting the timer. To make use of the boost, you just need to begin an AFK session while the boost is active. This item is global and will affect and stack with other players.

### Transaction Exploit Transmitter
This item affects globally and is used to boost BitCoin. Each Transaction Exploit Transmitter will provide a +40% boost to BitCoin gain for 20 minutes while stacking maxes out at 100%. You can use another to extend the duration of the boost, thus resetting the timer.

### Frontal Cortex Optimization Transmitter
This item affects globally and is used to boost EXP gains. Each Frontal Cortex Optimization Transmitter will provide a +80% boost to EXP gain for 20 minutes. Stacking does nothing other than resetting it's timer due to it's max boost. You can use another to extend the duration of the boost, thus resetting the timer.

### Calibration Shard
This item affects globally. It only affects for 5 minutes with a purpose to minimize the chance of calibration failure (ranging from 10% to 300%). It only stacks twice with each rarity (for example, the 10% (or called Rare Shard) can only stack with the other 10% and not with other variations such as 50% or even 100%). Explanation around Calibration can be found on [Calibration's Tutorial](https://cybercodeonline.com/markdown?path=tutorial%2Fcalibration.md)

### Safety Nano Calibration Bot
This item affects globally. It only affects for 5 minutes with a purpose to negate calibration failure (up to 100%). It stacks with other Safety Nano. Explanation around Calibration can be found on [Calibration's Tutorial](https://cybercodeonline.com/markdown?path=tutorial%2Fcalibration.md)

### Chat Exploit
This item does not give the player any benefits aside from altering chat text. It affects globally and can be interrupted by using **CyberTunnel VPN**. The Chat Exploit itself has a variety of alterations ranging from UwU (which UwU-ifies the text) up to Pirate (which alters the text into pirate speak).

### RNG Interferer
This item affects the drop percentage of **Legendary Container** (the effect only applies AFTER the buff starts and not before). When opening Legendary Container during the buff, it affects both Legendary (by 1%) & Epic (by 0.5%) drop percentage while also dropping additional item / loot to the table. These additional drop does not affect the probability of gaining either Legendary / Epic gear in the first place. It only affects for 2 minutes and affects globally.


## Modifiers
**Modifiers**. These modifiers can only be found in the dungeon, by picking up **Quest Giver** that is represented by `?` symbol. For full modifier list, can be found on [Combat's Tutorial](https://cybercodeonline.com/markdown?path=tutorial%2Fcombat.md)

Type / kinds of Modifiers can be summarized as follows:

### Overcharged
**Overcharged** affects player's damage within a span amount of time. The damage modifiers ranged from +5% (**Overcharged I**) up to +25% (**Overcharged V**)

### Reinforced
**Reinforced** affect player's defence within a span amount of time. The defence modifiers ranged from +5% (**Reinforced I**) up to +25% (**Reinforced V**)

### Shield Enhance  
**Shield Enhance** affect player's shield multiplier within a span amount of time. The shield multiplier modifiers ranged from +5% (**Shield Enhance I**) up to +25% (**Shield Enhance V**)


## Global Time Skips
Although these aren't items, players can also purchase global skips from their AFK screen (the Map tab when an AFK task is in progress). Skippers can choose from a range of 15 minutes to 180 minutes to skip. The time skips work with boosts, so it's more cost-efficient to use skips when boosts are already running.

As with all other paid items, time skips apply to everyone on the server. However, since they skip time immediately, only players who have started AFK tasks before the button is pressed will receive the benefit. Often it can be helpful to coordinate in global chat so player are ready to tag along.

The benefit is also applied to all AFK players one-by-one, so it may take 1 ~ 3 minutes for the effects to apply for everyone. Most regular skippers will recommend waiting around 1 minute after the skip button becomes available again, and purchasing 30-minute skips is the most popular choice when boosts are also running.
