# Equipment / Gears
You can equip an equipment (gear) that you own as long as the gear level that you wish to equip is not higher than your current character level.  

All equipment (and equipment caches) have rarities, as follows:
- Trash (Grey)
- Common (White)
- High Quality (Green)
- Rare (Yellow)
- Legendary (Fuchsia, Deep Pink)
- Epic (Dark Red)

Keep in mind that higher rarities will have better stats and more module upgrade slots, depending on the piece of equipment.  

## Knowing Your Caches
Here's a couple of guiding point on how or when to print certain caches:
> From level 1 to 5, it's recommended to print / use **Trash** caches for your gear set as it's the cheapest one of all
 
> From level 5 to 15, it's recommended to print / use **Common** caches for your gear set

> From level 15 to 30, it's recommended to print / use **High Quality** caches for your gear set

> From level 30 to 50, it's recommended to print / use **Rare** caches for your gear set

> From level 50+, it's recommended to print / use **Legendary** caches for your gear set

> From level 100+, it's recommended to print / use **Epic** caches for your gear set (if a player ever gets the chance to find or buy one, as it's the rarest cache / gear of all)

Keep in mind that this guidance were only served as a reference rather than enforcing players into managing certain plays. Also, **Gear Quality** reflects the stats on the gear itself perspectively, thus inspecting it's quality is essential for optimal gear stats.

## Finding Your Equipment
You can find both gear and equipment caches in dungeons or when fighting individual enemies (street fights). Once you are level 5, you will be able to use the Player Market to purchase different types of gears, crafting materials and other items.

## Printing Your Equipment
Caches can be used to print equipment at your current Printing Rank at the Molecular 3D Printer in the City Center. The level of the printed gear will be the same as your Printing Rank, so make sure to keep your Printing Rank at the same level as your player level.

## Repairing Your Equipment
When a player can't use their equipment (labeled by red text / color), it's indicated that player needs to repair their equipment for further uses. In order to repair your equipment, player needs to visit **Weapon Smith** that can be found in **Shangri-La City Center**. After entering the Weapon Smith, an option to **Repair Equipment** can be found below the **Sell** option. This option can only be availiable if player the equipped damaged gear & the gear's **Durability** are below 100%.

## Upgrade Modules
You can attach **Upgrade Modules** onto your equipment. In order to equip the module, the module level cannot be higher than the equipment's level (For example: you can't attach a level 20 upgrade module onto level 5 primary weapon).  

Upgrade modules can be removed at any time. Removed upgrade modules will take space in your inventory (it has a same unique inventory treatment as gear / equipment). Make sure you have enough space in your inventory before removing any upgrades.  

If your inventory is getting cluttered with upgrade modules that you can't rid of, you can always store unused module into your Bank Item Storage. 

It is advisable to remove the upgrade module before scrapping your unused gear as scrapping a piece of gear with module in it will only accounts as a module deletion. Always keep an eye on which item that you'll scrap as it's not recoverable.  

## Upgrade Slots
Each equipment has a dedicated **Upgrade Slots** depending on it's rarity and quality, which can be summarized as follows:

#### Primary Weapon
 - Trash: 0 to 1 Slots
 - Common: 1 to 2 Slots
 - High Quality: 2 to 3 Slots
 - Rare: 3 Slots
 - Legendary: 3 Slots
 - Epic: 4 Slots

#### Special Weapon
 - Trash: 0 to 1 Slots
 - Common: 1 to 2 Slots
 - High Quality: 2 Slots
 - Rare: 2 Slots
 - Legendary: 2 Slots
 - Epic: 3 Slots

#### Destructive Weapon
 - Trash: 0 to 1 Slots
 - Common: 1 to 2 Slots
 - High Quality: 2 Slots
 - Rare: 2 Slots
 - Legendary: 2 Slots
 - Epic: 3 Slots

#### Helmet
 - Trash: 0 to 1 Slots
 - Common: 1 to 2 Slots
 - High Quality: 2 Slots
 - Rare: 2 Slots
 - Legendary: 2 Slots
 - Epic: 3 Slots

#### Upper Armor
 - Trash: 0 to 1 Slots
 - Common: 1 to 2 Slots
 - High Quality: 2 to 3 Slots
 - Rare: 3 to 4 Slots
 - Legendary: 4 Slots
 - Epic: 5 Slots

#### Lower Armor
 - Trash: 0 to 1 Slots
 - Common: 1 Slot
 - High Quality: 2 Slots
 - Rare: 3 Slots
 - Legendary: 3 Slots
 - Epic: 4 Slots

#### Boots
 - Trash: 0 to 1 Slots
 - Common: 1 Slot
 - High Quality: 2 Slots
 - Rare: 2 Slots
 - Legendary: 2 Slots
 - Epic: 3 Slots

## Other Items
Explanation about other inventory such as parts and consumables, can be found on both [Inventory](https://cybercodeonline.com/markdown?path=tutorial%2Finventory.md) and [Resource's Tutorial](https://cybercodeonline.com/markdown?path=tutorial%2Fresources.md)
