## Dungeons

## Types of Dungeons
  
![DungeonTypes](/resources/mobile-tutorial/DungeonTypes.png)
  
These are the three types of dungeons that you are able to enter. The [normal] dungeon will include a key fragment in the treasure room and no boss. The [challenge] dungeon is a lot harder but includes more crates for loot and has a boss in the treasure room that gives a lot of EXP.  The [gang] dungeon is the hardest of all and requires that you are in a gang and have a Gang Invasion Order Transmitter.  Enemies are 4-5x stronger than normal dungeons but has greater rewards.

## Creating / Joining a Dungeon
  
When creating a dungeon, select the dungeon you want to create. You can name it and choose to make it Public or Private. You can also protect the dungeon with a password.

Public Dungeons are available to everyone to see and join (if they meet the level requirements) by accessing the list of dungeons. 

Password protected dungeons can be seen by other players but they cannot join unless they know the password. This is useful if you want to clear a dungeon with specific friends. Share the password in Gang chat or through Mail.

![DungeonCoop4](/resources/mobile-tutorial/DungeonCoop4.png)
![DungeonCoop3](/resources/mobile-tutorial/DungeonCoop3.png)

If you'd rather join an existing dungeon, you can press the floating menu button at the bottom right, then select the buildings icon to view a list of open dungeons, as shown above in the screenshots.

At the top right of each dungeon panel, you can find the dungeon level. Each panel includes a list of players and their status in the dungeon. At the bottom, you can see how many enemies are left. You can choose to join a fresher dungeon to gain more EXP or enter empty dungeons to claim loot.
 
![DungeonCoop](/resources/mobile-tutorial/DungeonCoop.png)
  
As shown in the images above, there are several players in the same dungeon. The rules are the same regardless of how many players are in a dungeon; the only difference is that players can help each other out. When using heals, players may use the AOE items (such as Pain Away Spray) to heal both yourself and your co-op partners. You can see everyone's health bars above the player icons. Players may also help dungeonmates by killing the enemy, as the HPs of dungeons enemies are shared by the whole co-op.

When an enemy is killed with the help from a friend, everyone who dealt 20% or more damage is given EXP and a chance for a reward, as long as their level isn't too high for the mob. All crates and loot are unique to each player, so you don't need to worry about sharing loot or having yours stolen. Grab everything you want and discard the rest!

![DungeonCoop2](/resources/mobile-tutorial/DungeonCoop2.png)

In this image, at the bottom under the '[QUIT DUNGEON]' button, you will find a button labeled '[Send invite to global chat]'. This will send an invite to the global chat so others can join easily by clicking on the message. Anyone around your level can join and help you out as long as they are within 10 levels below or 12 levels above your dungeon.

You can also click on messages from other players to join their dungeon.

After a player dies or leaves, they cannot rejoin the dungeon.
  
## Entrance and Icons
  
![DungeonEntranceUsed](/resources/mobile-tutorial/DungeonEntranceUsed.png)
  
Here you can see the first room of a dungeon. There are doors which will take you to another room in the dungeon. You can find these doors on all sides of the dungeon rooms.  You cannot enter a new room until you have killed all enemies in the current room.

This also shows an example of a room that has been completed. Note the greyed out crates, indicating that they have been looted already. The door on the right wall is also greyed out, which means you have already been through it. This is essential to not get lost while exploring the dungeon. 

### Enemies
  
![DungeonEnemies](/resources/mobile-tutorial/DungeonEnemies.png)
  
There are at most four alien looking icons spread across the room, and these are the enemies you have to defeat before proceeding to the next room or accessing the crates in the room. Click on one of them to fight them.
  
![DungeonFight](/resources/mobile-tutorial/DungeonFight.png)
  
Rules are slightly different in the dungeons when you fight enemies. You will have a row of 3 buttons above your attack options which you can assign to usable items from your inventory. You should assign medical items to this hotbar since your health doesn't regenerate automatically after each fight.

You also have an 'Escape' button on the top left. The success rate of you escaping is based on your player 'escape' stat.  
 
### Good Guy (?)
  
![DungeonGoodguy](/resources/mobile-tutorial/DungeonGoodguy.png)
  
Here, you can see the '?' icon, indicating a quest if you choose to accept it. You can find one quest giver per dungeon, and they are usually placed randomly in one of the rooms.
  
![DungeonGoodguy2](/resources/mobile-tutorial/DungeonGoodguy2.png)
  
Here is an example of the dialogue that pops up after clicking on the '?'. They will ask for items in return for other items or power-ups. It is up to you to decide if the trade is worthwhile; however, if you can afford it, it is usually worth accepting for the extra EXP you gain from completing it. Some of the text on this screen is randomly generated from a file, so you may get odd or funny references, if it makes any sense at all.

### Lore (!)

![DungeonLoreguy](/resources/mobile-tutorial/DungeonLoreguy.png)

There are exclamation marks dotted around dungeons that provide snippets of game lore. These don't have an impact on your game or the dungeon but may be interesting to read.

### Treasure / Boss Room
  
![DungeonBossTreasureCoop](/resources/mobile-tutorial/DungeonBossTreasureCoop.png)
  
This room is special, as you can tell from the increased number of crates. The crate that looks like a window contains a key fragment that can be used for crafting Secret Keys that unlock new areas.

In this screenshot, you can also see other players helping out. This is especially advised at low levels and when attempting a challenge dungeon, as the boss of challenge dungeons has greatly increased health and power in return for more EXP.

### Minigame

Once in a while, a minigame will show up after defeating an enemy, when trying to loot a box, or when entering another room, to insinuate a variety of dungeon dwellings. At the current state (as of 11-02-2022 / v.0780 Update), there's only 1 minigame that's been implemented to the game, called **Color Scheme Minigame**.

![DungeonMinigame1](/resources/mobile-tutorial/DungeonMinigame1.png)

The minigame itself consists of 3 colors (red, green, and yellow; with added symbols as an accessibility add-on) that need to be clicked on in sequence (40 times) in 60 seconds. You can also see the upcoming 2 colors as thinner color strips.

![DungeonMinigameFail1](/resources/mobile-tutorial/DungeonMinigameFail1.png)

Failing a minigame will result in a `DECRYPTION FAILED` screen, stating that a player failed to pick a correct color in sequence. Players are able to redo the minigame by clicking the **Try Again** button.
