## 家具システムとは？

家具システムは、プレイヤーに小さなステータスボーナスを提供する後期ゲームのコレクションシステムです。レベル300以上のプレイヤーが家具を作成してアパートに設置し、永続的なステータスボーナスを得られます。家具からボーナスステータスを得るには、`エナジーセル`を使って有効化する必要があります。

## 家具スロットはいくつありますか？

家具スロットの数はアパートのランクに基づきます。
基本的に、アパートのランクが高いほど、家具スロットが多くなります。
詳細はアパートの詳細をご覧ください。

## 家具素材の入手方法は？

`クリスタルサンド`でAFKタスクを完了して素材を集めます（レベル300以上が必要）：

`座礁した技術貨物のサルベージ`（主要な素材源）

- 消費：`AIコア`と`テックスクラップ`
- 報酬：`合成ポリマー`、`合金フレーム`、`スマートファブリック`

`動力ユニットのサルベージ`（有効化用のエナジーセル）

- 消費：`AIコア`と`テックスクラップ`
- 報酬：`エナジーセル`（主要）、小確率でクラフト素材

## 家具の作成方法は？

家具クラフトは段階的な`組み立てキット`システムを使用します：

1. `基本家具組み立てキットを作成`

   - 必要：`合成ポリマー`、`合金フレーム`、`スマートファブリック`
   - 必要レベル：300

2. `高度なキットにアップグレード`

   - 必要：複数の`基本キット`
   - 必要レベル：400

3. `高級キットにアップグレード`

   - 必要：複数の`高度なキット`
   - 必要レベル：500

4. **キットを家具と交換**
   - `クリスタルサンド`の`家具ベンダーNPC`を訪れる
   - 1つのキットでそのランクの任意の家具と交換
   - 欲しい特定の家具を選択

> **注意：**まずキットを作成し、その後家具ベンダーと交換する必要があります。家具を直接作成することはできません。

## すでにキットを家具と交換したのに、ステータスボーナスが得られないのはなぜですか？

以下の理由が考えられます：

- 家具を所有しているがまだアパートに配置していない。
- 家具をアパートに配置したが有効化していない。有効化された家具のみがステータスボーナスを提供します。

## 家具の有効化方法は？

1. インベントリに十分な`エナジーセル`があることを確認
2. アパートから`家具ページ`を開く
3. 有効化したい家具を選択し、まだ割り当てていない場合は家具を割り当てる。
4. `有効化`ボタンをクリック
5. 使用可能なスロットがある場合、家具は自動的に有効になります

> **注意：**有効化された家具は定期的に再有効化が必要です。

## 家具の無効化方法は？

アパートから家具を取り外すだけです。家具の所有権は維持されますが、ステータスボーナスは提供されません。

## アパートを家具の数より少ないスロットにダウングレードしたらどうなりますか？

現在のアパートを退去すると、すべての家具スロットがクリアされるため、新しいアパートを借りる際に家具を新しいアパートに再割り当てする必要があります。

## アパートなしで家具を使えますか？

いいえ。家具ボーナスはアクティブなアパートレンタルがある場合のみ適用されます。アパートレンタルが期限切れになった場合：

- 家具の所有権は保持されます
- 有効化された家具はカウントダウンを続けます
- 別のアパートを借りて家具を新しいアパートに割り当てるまで、ステータスボーナスは得られません。

## 家具の期限が切れたらどうなりますか？

有効化時間が期限切れになった場合：

- 家具は自動的に無効化され、ボーナス提供を停止します
- 家具はインベントリとアパートスロットに残ります。
- いつでも再び有効化できます。

## 同じカテゴリの複数の家具を重ねることはできますか？

はい。同じカテゴリの複数の家具を有効化してボーナスを重ねることができます。

## 同じ家具を複数所有できますか？

いいえ。各特定の家具タイプは**プレイヤーごとに1つのみ**所有できます。重複する家具と交換することはできません。

**例：**`ニューラルインターフェースデスク`（ランク1スタディ）を1つ所有できますが、`ホログラフィックターミナル`（ランク2スタディ）も所有できます。これらは異なる家具タイプだからです。

## ランクの違いは何ですか？

各カテゴリ内のすべての3つのランクは**同一のステータスボーナス**を提供します。

- **ランク1**（レベル300以上）
- **ランク2**（レベル400以上）
- **ランク3**（レベル500以上）

パワーレベルではなく、好みやレベルの利用可能性に基づいて選択してください。

## 家具システムのコストは？

**素材収集**：

- 素材を集めるために複数のAFKタスク実行が必要
- 実行ごとに`AIコア`と`テックスクラップ`が必要
- 組み立てキットのクラフトに`BTC`が必要

**家具有効化**（定期メンテナンス）：

- 家具ごとに`エナジーセル`が必要
- エナジーセルを集めるために定期的なAFKタスク実行が必要

## 家具システムにはどこでアクセスできますか？

- `クリスタルサンド` - AFKタスクと`家具ベンダーNPC`の場所（レベル300以上が必要）
- `アパートページ` - 家具管理インターフェースへのアクセス
- `クラフトメニュー` - 組み立てキットのクラフト
