# キャリブレーション
![CalibrationStation](/resources/mobile-tutorial/CalibrationStation.png)

**キャリブレーション**とは, 装備を強化することのできるシステムです. 後々高いレベルになった時まで, 装備を長く使い続けることができます. キャリブレーションを行っても装備のレベルは上がりませんが, +1, +2という風にプラス値が装備に付与され, 一定の段階まで基本ステータスを上げることができます. キャリブレーション可能なレベル上限は装備のレアリティごとに決められており, またキャリブレーションは一定の確率で失敗して装備が破壊されます.

装備レアリティ毎のキャリブレーションレベル上限, 各レベルごとの装備の強化割合(無強化の場合に対するステータス比率)および失敗する確率は以下の通りです.

| レアリティ | レベル | 強化割合 | 失敗する確率 |
|:--:|:--:|--:|--:|
| ゴミみたいな | +1 | 105% | 2% |
| ゴミみたいな | +2 | 110% | 5% |
| ゴミみたいな | +3 | 115% |10% |
| 普通 | +4 | 120% | 15% |
| 高品質 | +5 | 140% | 50% |
| レア | +6 | 160% | 100% |
| 伝説 | +7 | 180% | 150% |
| 伝説 | +8 | 210% | 200% |
| 英雄 | +9 | 250% | 400% |
| 英雄 | +10 | 300% | 666% |

制限というわけではありませんが, レベル50以上になってからキャリブレーションを開始することをお勧めします. というのも, 低レベルのうちはより高いレベルの装備への更新頻度が高いため, せっかく装備をキャリブレーションしてもすぐに使わなくなってしまうからです. また, レアリティが高い装備ほどキャリブレーションできる回数が多いため, 少なくともレア（黄色）以上の装備でキャリブレーションを行うことを推奨します.

> キャリブレーションは効果的な装備の強化方法ですが, 手順が複雑なため大切な装備品を壊してしまう可能性があります.
> 最初から英雄の装備などのとっておきの装備品を強化するのではなく, 事前に**壊れても良い装備で強化の練習をして手順を確認しておきましょう!!**

## キャリブレーションの仕方
![CalibrationStation2_ja](/resources/mobile-tutorial/CalibrationStation2_ja.png)

シャングリ・ラ中心街にある**キャリブレーションステーション**に行くと, 処理を開始するために**装備キャリブレーションコア**を挿入するよう言われます. コアを挿入してから装備のキャリブレーションが可能になるまで, 30分ほど待機する必要があります（**この待機時間は, AFKアクセラレータ［シナプス加速伝達機］を含むグローバルバフ/スキップの影響を受けません**）.

![CalibrationStation3_ja](/resources/mobile-tutorial/CalibrationStation3_ja.png)

30分が経過した後, プレイヤーはインベントリにある装備品（キャリブレーションレベルが最大になっている装備を除く）のキャリブレーションを行えるようになります. 装備している場合は外してください.

## キャリブレーションステーションの外で装備の強化を行う

v0.780 (2022/03/04)以降, AFKタスクやダンジョンの途中でもキャリブレーションができるようになりました.

![CalibrationStationAlt_ja](/resources/mobile-tutorial/CalibrationStationAlt_ja.png)

キャリブレーションを行うには, 装備をクリックして「詳細を見る」を選択してください. **装備の詳細**画面に移動したら, **アップグレード**か**アップグレード上限**と書いてあるボタンをクリックすることで, キャリブレーションステーションに移動することができます. これで簡単にキャリブレーションが行えます.

装備されていない状態のアイテムしかキャリブレーションできない事をお忘れなく！ 戦闘中でも装備の付け外しは可能なので, 一度インベントリに戻してから強化し, また改めて装備し直してください.

## 装備が破壊される確率

![CalibrationStation4_ja](/resources/mobile-tutorial/CalibrationStation4_ja.png)

装備のキャリブレーションを行う過程で, 処理に失敗して**装備が破壊**される可能性があります. 失敗する確率は, 選択された装備の上に赤い数字で表示されます.

処理に失敗すると, 装備はもちろんその装備に装着されているアップグレードモジュールも共に破壊されます. そのため, キャリブレーションを行う前にモジュールを取り外しておくことをお勧めします.

## 失敗する確率を減少させるには

> 2024年8月のUpdate0.1839以降, すべてのキャリブレーションブーストに関するアイテムは新たに入手できなくなりました.  
> 過去に入手したアイテムは引き続き利用できますが, 現在はキャリブレーションブーストはキャリブレーションステーションで所定のUNITを消費して失敗確率を下げる方法に統一されています.  

レベルが+6以上のキャリブレーションは失敗する確率が100％以上となるため, 失敗する確率を減少させる**キャリブレーションブースト**を使用しないと実行が**不可能**です.

キャリブレーションブーストのティア, 及び入手できる場所は以下の通りです.
- **キャリブレーションAIのかけら（5%）** 自分自身のみに機能し, 失敗する確率を5%減少させます. これは「鍵のかかった珍しいコンテナ」から手に入れることができます.
- **キャリブレーションAIのかけら（10%）** グローバルバフです. 失敗する確率を10%減少させます.
- **キャリブレーションAIのかけら（50%）** グローバルバフです. 失敗する確率を50%減少させます.
- **キャリブレーションAIのかけら（100%）** グローバルバフです. 失敗する確率を100%減少させます.
- **キャリブレーションAIのかけら（300%）** グローバルバフです. 失敗する確率を300%減少させます.

また, イベント限定の「神秘的なコンテナ」や入手できる「キャリブレーションセーフティナノボット」を起動させてからキャリブレーションを行うと, キャリブレーションに失敗した場合の破壊効果を無効化することができます.

ブーストは5分間しか持続せず, 各ティア/レアリティのブーストは2回までしか重ねられないことに注意してください（キャリブレーションAIのかけら（5%）を除く）. ブーストする前に準備しておくとよいでしょう.

## キャリブレーションを行った装備の取引/販売
キャリブレーションを行った装備は, 取引または販売を行うことはできません. 取引や販売を行うには**リセットシャード**（収集やマーケットで入手可能）を使用して, キャリブレーションを行った装備をリセットする必要があります.


## キャリブレーショントレイン資金
キャリブレーショントレイン資金については, クエストからご覧ください.
