## What Are Loadouts?

Loadouts are saved configurations of your equipped items that can be quickly applied to your character. Instead of manually equipping and unequipping items for different situations, loadouts allow you to save your favorite equipment setups and switch between them with a single tap.

## Benefits of Using Loadouts

-   **Save time** by quickly switching between different equipment setups
-   **Optimize your character** for different gameplay scenarios (AFK, dungeon, resource gathering, etc.)
-   **Adapt quickly** to changing gameplay situations

## How to Access Loadouts

You can access the Loadout system from the **Equipment tab** - Look for the "Loadouts" button

## Creating Your First Loadout

1. Access the loadout page from inventory and click the `Loadout` button
2. Tap the "Create Loadout" button
3. Enter a name for your loadout (e.g., "AKF Setup", "Dungeon Run", etc.)
4. Update the loadout with the items you want to equip
5. Confirm to save your loadout

## Managing Your Loadouts

### Applying a Loadout

You can apply a loadout by clicking the `Equip this set` button on the loadout page.

> **Note:** If any equipment in your loadout is in the vault, or no longer in your inventory, they won't be equipped. Equipments that are no longer in your inventory will not be shown in the loadout page automatically.

### Editing a Loadout

You can edit any existing loadout by click on the slots and select different equipments.

### Deleting a Loadout

You can delete any existing loadout by click on the `Delete` button on the loadout page.

## Increasing Maximum Loadout Slots

Your maximum number of loadout slots increases as you level up your character:

| Player Level | Maximum Loadout Slots |
| ------------ | --------------------- |
| 0            | 1                     |
| 100          | 2                     |
| 300          | 3                     |
| 500          | 4                     |

To get more loadout slots, focus on leveling up your character through combat, quests, and other activities that grant experience points.

## Troubleshooting

If you encounter issues with your loadouts:

-   **Missing Items:** Items that are no longer in your inventory won't be equipped. They will also be removed from your loadout.
-   **Items in vault:** Items stored in your vault need to be retrieved before they can be equipped
