## What is the Furniture System?

The Furniture System is a late game collectible system that provides minor stat bonuses to the player. It allows level 300+ players to craft and install furniture in their apartments that provides permanent stat bonuses. To receive bonus stats from the furniture, you need to activate them using `Energy Cells`.

## How many furniture slots do I have?

The number of furniture slots is based on the apartment tier.
Basically, the higher the apartment tier, the more furniture slots you have.
For more information, please see apartment details.

## How do I get furniture materials?

Complete AFK tasks in `Crystal Sands` (level 300+ required) to gather materials:

`Salvage Beached Tech Cargo` (Primary materials source)

- Costs `AI Cores` and `Tech Scrap`
- Rewards: `Synthetic Polymer`, `Alloy Frame`, `Smart Fabric`

`Salvage Power Units` (Energy Cells for activation)

- Costs `AI Cores` and `Tech Scrap`
- Rewards: `Energy Cells` (primary), with small chance for crafting materials

## How do I craft furniture?

Furniture crafting uses a progressive `Assembly Kit` system:

1. `Craft Basic Furniture Assembly Kit`

   - Requires: `Synthetic Polymer`, `Alloy Frame`, `Smart Fabric`
   - Level required: 300

2. `Upgrade to Advanced Kit`

   - Requires: Multiple `Basic Kits`
   - Level required: 400

3. `Upgrade to High-End Kit`

   - Requires: Multiple `Advanced Kits`
   - Level required: 500

4. **Trade kit for furniture**
   - Visit the `Furniture Vendor NPC` in `Crystal Sands`
   - Trade 1 kit for any furniture in that tier
   - Choose the specific furniture you want

> **Note:** You must craft kits first, then trade them with the Furniture Vendor. You cannot craft furniture directly.

## I already traded my kit for furniture, why am I not getting the stat bonuses?

This could be caused by the following reasons:

- You have the furniture but have not placed it in your apartment yet.
- You have placed the furniture in your apartment but have not activated it yet, only activated furniture can provide stat bonuses.

## How do I activate furniture?

1. Ensure you have enough `Energy Cells` in your inventory
2. Open your `Furniture page` from your apartment
3. Select the furniture you want to activate, assign the furniture if you have not already done so.
4. Click the `Activate` button
5. Furniture automatically enables if slots are available

> **Note:** Activated furniture requires periodic reactivation.

## How do I disable a furniture?

You can simply remove the furniture from your apartment. You will still own the furniture but it will not provide stat bonuses.

## What happens if I downgraded my apartment to less slot than I have furniture?

When you leave your current apartment, all furniture slots will be cleared, so when you rent a new apartment, you will need to assign the furniture to the new apartment.

## Can I use furniture without an apartment?

No. Furniture bonuses only apply when you have an active apartment rental. If your apartment rental expires:

- Your furniture ownership is preserved
- Activated furniture continues counting down
- You receive zero stat bonuses until you rent another apartment and assign the furniture to the new apartment.

## What happens when furniture expires?

When activation time expires:

- Furniture automatically disables and stops providing bonuses
- Furniture remains in your inventory and assigned to the apartment slot.
- You may activate them at any time again.

## Can I stack multiple furniture from the same category?

Yes. You can activate multiple furniture from the same category to stack bonuses.

## Can I own the same furniture multiple times?

No. Each specific furniture type can only be owned **once per player**. You cannot trade for duplicate furniture.

**Example:** You can own one `Neural Interface Desk` (Tier 1 Study), but you can also own `Holographic Terminal` (Tier 2 Study) since they are different furniture types.

## What are the tier differences?

All three tiers within each category provide **identical stat bonuses**.

- **Tier 1** (Level 300+)
- **Tier 2** (Level 400+)
- **Tier 3** (Level 500+)

Choose based on preference or level availability, not power level.

## How much does the furniture system cost?

**Material Gathering**:

- Requires multiple AFK task runs to gather materials
- Costs `AI Cores` and `Tech Scrap` per run
- `BTC` required for crafting Assembly Kits

**Furniture Activation** (periodic maintenance):

- Costs `Energy Cells` per furniture
- Requires regular AFK task runs to farm Energy Cells

## Where can I access the furniture system?

- `Crystal Sands` - Location for AFK tasks and `Furniture Vendor NPC` (level 300+ required)
- `Apartment page` - Access furniture management interface
- `Crafting menu` - Craft Assembly Kits
