## Dungeons

Dungeons are one of the game features that allow a player to delve into cyberspace to fight mobs and bosses. These activities will result in giving players EXP (Experience), BTC (Bitcoin), and loot or rewards, as the reward itself ranges from trash tier gear up to epic tier gear (and or caches).

Dungeons were designed as a player-versus-enemy (or PvE) format, with the player itself can join other players' dungeon (as long as it's public [normal or challenge dungeon] or in the same gang [gang dungeon]). When in the same dungeon, all players will have a different pool of rewards or loot, making it accessible for all players.

### Types of Dungeons

![DungeonTypes](/resources/mobile-tutorial/DungeonTypes.png)

There are three types of dungeons that players can enter, as follows:

-   Normal Dungeon: This dungeon includes a key fragment (which can be found in the **Treasure Room**), and relatively easy-to-beat mobs.
-   Challenge Dungeon: Same as Normal Dungeon, but with more challenging mobs. This time, **Bosses** were added to the **Treasure Room**
-   Gang Dungeon: Exclusive to only gang members; 4x-5x more rewarding than Challenge Dungeon, with even more challenging mobs. Players were recommended to only enter the Gang Dungeon after level 50 & with proper gear (Legendary+)

### Creating / Joining a Dungeon

When creating a dungeon, select the dungeon that the player wants to create. Players can name it and choose to make it Public or Private. Players can also limit the accessibility of the dungeon by adding an additional password to the space. Public Dungeons are available for everyone to see and join (if players met the area & level requirements) by accessing the list of dungeons (which can be found on Phone Icon > Dungeon List).

Password-protected dungeons can be seen by other players but they cannot join unless they know the password. This is useful if players want to clear a dungeon with specific friends. Share the password in Gang chat or through Mail.

![DungeonCoop3](/resources/mobile-tutorial/DungeonCoop3.png)

If players rather joined an existing dungeon, players can press the floating phone icon at the bottom right of the in-game screen, then select the buildings icon (Dungeon List) to view a list of open dungeons, as shown above in the screenshots.

At the top left & right of each dungeon panel, players can find the name of the dungeon, and also the types of it. Each panel includes information about the dungeon, followed by the area's name, level requirements, the key fragment that players can obtain, and the number of players that are connected to the same dungeon. Players can choose to join a fresher dungeon to gain more EXP or enter empty dungeons to claim their loot.

![DungeonCoop](/resources/mobile-tutorial/DungeonCoop.png)

As shown in the images above, there are several players in the same dungeon. The rules are the same regardless of how many players are in a dungeon; the only difference is that players can help each other out. When using heals, players may use the AOE (or Area of Effect) items (such as Pain Away Spray) to heal both players themselves and their co-op partners. Players can see everyone's health bars above the player icons. Players may also help their dungeon buddies by killing the enemy, as the HPs of dungeons enemies are shared by the whole co-op.

When an enemy is killed with the help of a friend, everyone who dealt 20% or more damage is given EXP and a chance for a reward (Bosses drops are guaranteed), as long as their level isn't too high for the mob. All crates and loot are unique to each player, so players don't need to worry about sharing loot or having yours stolen. Grab everything players want and discard the rest!

![DungeonCoop2](/resources/mobile-tutorial/DungeonCoop2.png)

 In this image, at the bottom under the `[Quit Dungeon]` button, players will find a button labeled `[Send Invite to Global Chat]`. This will send an invite to the global chat (excluding Gang Dungeon; it will send to Gang Chat instead) so others can join easily by clicking on the message. Anyone around players' level can join and help players out as long as they are within 10 levels below or 12 levels above players' dungeon. Players can also click on messages from other players to join their dungeon.

After a player dies or leaves, they cannot rejoin the dungeon. The dungeon will still be open until the last person in the dungeon itself were leaving or dies.

## Entrance and Icons

![DungeonEntranceUsed](/resources/mobile-tutorial/DungeonEntranceUsed.png)

Here players can see the first room of a dungeon. There are many/few doors that will take players to another room in the dungeon. Players can find these doors on all sides of the dungeon rooms. Players cannot enter a new room until players have killed all enemies in the current room.

Whenever a player enters another room, the doors that the player enters will change their white-looking color into a greyed-out color, indicating that they have been entered before. The same thing can be said with loot crates, containers, quests, and lore, as players have interacted with them. This is essential to not get lost while exploring the dungeon.

### Enemies

![DungeonEnemies](/resources/mobile-tutorial/DungeonEnemies.png)

At most, a normal mob room will consist of 3 to 4 alien-looking icons spread across the room (unless it's a Treasure Room, which will have at least 5 or more mobs inside [including 1 Boss]), and these are represented as the enemies inside the dungeon, and players have to defeat them before proceeding to the next room or accessing the crates in the same room.

![DungeonFight](/resources/mobile-tutorial/DungeonFight.png)

Rules are slightly different in the dungeons when players fight enemies. Players will have a row of buttons above players' attack options which players can assign to usable items from players' inventory. Players should assign medical items to this Hotbar since players' health doesn't regenerate automatically after each fight (unless the player had a **Regen** built on their stats/gear).

Players can also `Escape` the fight by clicking the **Escape** button on the top left of the in-game screen. The success rate of players escaping is based on players' `escape` stats.

### Quest Giver (?)

![DungeonGoodguy](/resources/mobile-tutorial/DungeonGoodguy.png)

Here, players can see the question mark (?) icon, indicating a quest if players choose to accept it. Players can find one quest giver per dungeon, and they are usually placed randomly in one of the rooms.

![DungeonGoodguy2](/resources/mobile-tutorial/DungeonGoodguy2.png)

Here is an example of the dialogue that pops up after clicking on the '?'. They will ask for items in return for other items or power-ups. It is up to players to decide if the trade is worthwhile; however, if players can afford it, it is usually worth accepting for the extra EXP players gain from completing it. Some of the text on this screen is randomly generated from a file, so players may get odd or funny references (if it makes any sense at all).

### Lore (!)

![DungeonLoreguy](/resources/mobile-tutorial/DungeonLoreguy.png)

There are exclamation marks (!) dotted around dungeons that provide snippets of the game lore. These don't have an impact on players' game or the dungeon but may be interesting to read.

### Treasure / Boss Room

![DungeonBossTreasureCoop](/resources/mobile-tutorial/DungeonBossTreasureCoop.png)

This room is special, as players can tell from the increased number of crates & have at least 5 or more mobs inside. The crate that looks like a window contains a key fragment that can be used for crafting Secret Keys that unlock new areas.

In this screenshot, players might see that these other players were "solo" -ing the dungeon. This may be plausible on a higher level, but in a lower level or gangmates context, players were advised to do a dungeon with at least 2 or more players, as there are many benefits in doing a co-op dungeon, such as time-efficient dungeon clearing and loot sharing.

### Dungeon Lingo

**Dungeon Lingo** or abbreviation is one of few ways for players to communicate with their dungeon buddies in order to navigate them towards a goal (in this case, are finding the **Treasure Room** & its **Bosses** inside their dungeon). Here are a few lingoes that most players were frequently used during their dungeon sessions:
  
| Lingo | Description |
|--|--|
| [number] | Indicate the number of doors inside the dungeon (ex. 0) |
| [direction] | Indicate the players next location; stated that there's another door inside (ex. R [/ Right])  |
| [number] [direction] | Indicate the amount of doors of stated direction (ex. 0 R) |
| DE  | Indicate that player found a **Dead End**, meaning that there's no door nearby (except the ones that the player enters) |
| BR | Indicate that there's a **Treasure / Bosses Room** inside players location |
| B  | Indicate that player found the boss |
| B [type] | Indicate that player found the boss while stating the types of it (ex. B Agile) |
| G | Indicate that players hit the requirement of getting Bosses reward (20% or more) |
| G? | Confirming to other players if they have already reach the requirement |
| M / Minigame | Indicate that players were facing a minigame at the moment |
| OMW  | "On My Way (towards a certain goal)" |
| BRT | "Be Right There (towards a certain goal)" |

### Minigame

Once in a while, a minigame will show up after defeating an enemy, when trying to loot a box, or when entering another room, to insinuate a variety of dungeon dwellings. At the current state (as of 11-02-2022 / v.0780 Update), there's only 1 minigame that's been implemented to the game, called **Color Scheme Minigame**.

![DungeonMinigame1](/resources/mobile-tutorial/DungeonMinigame1.png)

The minigame itself consists of 3 colors (red, green, and yellow; with added symbols as an accessibility add-on) that need to be clicked on in sequence (40 times) in 60 seconds. Players can also see the upcoming 2 colors as thinner color strips.

![DungeonMinigameFail1](/resources/mobile-tutorial/DungeonMinigameFail1.png)

Failing a minigame will result in a `DECRYPTION FAILED` screen, stating that a player failed to pick a correct color in sequence. Players are able to redo the minigame by clicking the **Try Again** button.
