# Calibration
![image](https://github.com/DexterHuang/CyberCodeOnline/assets/18545294/84a0f895-5a3e-4648-b93d-375ae1a469c2)

**Calibration** upgrades gear for longevity and usability at higher levels, but doesn't increase its level - it only increases its base stats to a certain tier.

Start **calibrating** gear at level 50 or higher to avoid quickly outgrowing it on longer runs. Calibrate at least Rare (up to Epic) gear for more tiers to improve.

To **calibrate** an item, you need to visit the Calibration Station that can be found at the Shangri-La City Center (Map).

## Performing Calibration
![CalibrationStation2](/resources/mobile-tutorial/CalibrationStation2.png)

Inside the **Calibration Station**, the player will be asked to insert the **Equipment Calibration Core** to start the process. After inserting the core, the player needs to wait for 30 minutes before the Station allows the player to calibrate their gear (**This waiting process is not affected by any global buff / skips, including AFK Accelerators [Synaptic Acceleration Transmitter]**).

![CalibrationStation3](/resources/mobile-tutorial/CalibrationStation3.png)

After inserting an **Equipment Calibration Core** and waiting 30 minutes, A player is allowed to calibrate any gear (excluding maxed calibrated Gear) that's not equipped into their equipped slot. 

## Outside of Calibration Station

As of **v0.780 (2022/03/04) update**, players were allowed to calibrate gear during the AFK Task / Dungeon session. 

![CalibrationStationAlt](/resources/mobile-tutorial/CalibrationStationAlt.png)

To calibrate their gear, players can click on the designated gear, select 'View Details,' and then click either the **Upgrade** or **Calibration Slots** button in the **Equipment Details** section to navigate to the Calibration Station.

Keep in mind that only unequipped gear can be calibrated.

## Chance of Destructive Failure

![CalibrationStation4](/resources/mobile-tutorial/CalibrationStation4.png)

While calibrating gear, there's a chance it may fail and be destroyed, indicated by a red percentage number on the gear.

Before calibrating gear, it's advisable to remove any attached Upgrade Modules to avoid the risk of both the gear and module being destroyed in case of failure.

In general, the gear capacity / fail percentage of each tier is as follows:
| Gear Capacity | Tier | Chance to Fail |
|--|--|--|
| Trash | +1 | 2% |
| Trash | +2 | 5% |
| Trash | +3 | 10% |
| Common | +4 | 15% |
| High Quality | +5 | 50% |
| Rare | +6 | 100% |
| Legendary | +7 | 150% |
| Legendary | +8 | 200% |
| Epic | +9 | 400% |
| Epic | +10 | 666% |

## Override The Chance
Calibrating to +6 or beyond is *impossible* since the fail chance is 100% or greater. To increase the chance of success, players can use **Calibration Buffs** to override the fail chance.
To deploy the buff, simply click on the `Increase Success Rate` button, this will deploy the buff for **Everyone on the server**, you then can see the updated chance with current increased chance by the buffs as shown below:

![image](https://github.com/DexterHuang/CyberCodeOnline/assets/18545294/7d45ef02-a914-482d-83fe-0a9c9cd19c06)


You may also use `Destruction Prevention` to prevent your equipment from being permanently destroyed when calibration fails by clicking `Prevent Destruction`, this will deploy the `Destruction Prevention` buff for everyone for 5 minutes

Keep in mind that boosts last for **only 5 minutes** and each tier/rarity **can only be stacked twice** (except Common Shards), so it's best to be prepared before using them.

## Gear Improvement
Each calibration improves gear significantly, with improvements including increased health, damage, and inventory slots, depending on the gear's level.

Improvement (from calibration; from its base stats) percentage as follows:
| Tier | Gear Improvement |
|--|--|
| +1 | 5% |
| +2 | 10% |
| +3 | 15% |
| +4 | 20% |
| +5 | 40% |
| +6 | 60% |
| +7 | 80% |
| +8 | 110% |
| +9 | 150% |
| +10 | 200% |


##  Trade / Sell Calibrated Gear 
Calibrated gear cannot be traded or sold, but players can **Reset** it using a **Factory Reset Shard**, which can be found on Scavenge or Market, to enable trading or selling of related gear.
