# Global Skip

**Global Skip** is an in-game feature that allows players to accelerate AFK times up to a certain duration. When a player activates Global Skip, it affects every player that started their AFK task beforehand. As the benefit applies to all AFK players, it adds to the queue system and progresses one by one. It takes 1 ~ 3 minutes for the effects to apply to everyone (it might take even longer depending on how big the queue is).

![GlobalSkip](/resources/mobile-tutorial/GlobalSkip.png)

To activate Global Skip, players must acquire a premium currency called Units which can only be bought with Real Money. The cost for Global Skip depends on the duration that applies, with an increment of 64 Units for every 15 minutes (for example: if a player wants to do a 30 minute Global Skip, it'll cost them 128 Units on doing so).

![GlobalSkip2](/resources/mobile-tutorial/GlobalSkip2.png)

Players can do Global Skip for up to 8 hours AFK task, which costs 2048 Units upon purchase. It is advisable to wait for at least 10-30 seconds before applying Global Skip so that other players can gain the benefit at times. Once purchased, no new skips can be purchased until the skip is completed.

## Global Skip & Efficiency

While doing a sole Global Skip was a thing, players were advised to do a Global Skip while having a certain **Accelerator / Global Buff** that makes the Skip more efficient per cost. In general, the Global Buff itself is as follows:

### Synaptic Acceleration Transmitter

![GlobalBuff_AFK](/resources/mobile-tutorial/GlobalBuff_AFK.png)

This item will boost how quickly AFK time passes by +5% for 10 minutes, stackable to +80%. Players only need to use one at times to extend the duration of the boost, resetting the timer. To make use of the boost, players need to begin an AFK session while the boost is active. This item affects globally and does not stack with the rare version. Players can only find this item on Dungeon or via Player Trade.

### Rare Synaptic Acceleration Transmitter

![GlobalBuff_AFK2](/resources/mobile-tutorial/GlobalBuff_AFK2.png)

These are similar to regular **Synaptic Acceleration Transmitters** but don't stack with them. The rare version will instantly boost how quickly AFK time passes by +40% for 20 minutes, stackable to +80%. You only need to use one at times to extend the duration of the boost, resetting the timer. To make use of the boost, you just need to begin an AFK session while the boost is active. You can only find this item on Dungeon or buy one via Arasaka Unit Exchange.

### Transaction Exploit Transmitter

![GlobalBuff_BTC](/resources/mobile-tutorial/GlobalBuff_BTC.png)

The **Transaction Exploit Transmitter** is used to boost BitCoin gains and works the same way as the transmitters in that you can use multiple to stack the effect and prolong the timer. Each Transaction Exploit Transmitter will provide a +40% boost to BitCoin gain for 20 minutes. Stacking maxes out at 100%.

### Frontal Cortex Optimization Transmitter

![GlobalBuff_EXP](/resources/mobile-tutorial/GlobalBuff_EXP.png)

The **Frontal Cortex Optimization Transmitter** is used to boost EXP gains. Each Frontal Cortex Optimization Transmitter will provide a +80% boost to EXP gain for 20 minutes.

As for efficiency, players were advised to buy both **Rare Synaptic Acceleration Transmitters** and use both of them before Global Skip applies. This way, players can get more AFK tasks per Global Skip duration than per casual timer.

Here's a quick example of it:

-   If a player applies 2 hour / 120 minutes Global Skip for one task alone, it'll cost them **512 Units**.
-   If a player used both Rare Synaps (costs 64 Units x 2), a 2 hours task now cuts into a 24 minutes task, which allows them to do 30 minutes Global Skip (costs 128 Units) instead. This brings in a total of **256 Units** (and a bonus of 2 more 30 minutes Global Skips with the same previous Units total).

It is optional to use other Global Buff (such as Transaction Exploit or Frontal Cortex) as it accounts as a bonus buff for every player.

## Respecting The Skipper

When a Global Skip occurs, the game will tell as for who's the skipper is in a format of a system message on Chat's room. The information itself shows the duration of the skip and the total of a queue for that skip duration.

![SkipperRespect](/resources/mobile-tutorial/SkipperRespect.png)

When a skip is initialized, a unique button (represented with a fast forward icon) will appear on the right side of the Chat room, at the top of the "Send" button. The fast forward-like button was referred to as a **Skipper Respect** button. This button alone will only appear during Global Skip and vanish after Global Skip is finished.

![SkipperRespect2](/resources/mobile-tutorial/SkipperRespect2.png)

It's been told that whenever a player taps the button (indicated by colored hearts / snowflakes), there's a chance that a player itself will win a prize from it. The prize themselves ranged from Medical Tech, AI Cores, Backpack, and Epic Gear. This activity was referred to as a **Skip Raffle**.

At times, the hearts / snow effects might lag the game (depending on the player's phone specs), resulting in a mixed experience in between. Players can disable the effect (which also prevents them from joining Skip Raffle) by tapping the Phone Icon on either Map or Profile tab and choosing the Settings option.
