# Update Notes

If you found a bug please post a bug report in our [Discord server](https://discord.gg/JREx8xz) Bug report channel.

Did you like the game and fancy helping the game? you can:
- Leave a 5-star review on the store, this will help others see the game more
- Report bugs or suggestions for improvement to our Discord, the developer checks Discord frequently (due to time limitations I can't really check Reddit or other places)
- Deploy some global buff or skips for the community
- Contribute to our WIKI, Lores and other configs on our [GitHub](https://github.com/DexterHuang/CyberCodeOnline)

### Contributable files:

-   contribution/words.json - Random Words
-   contribution/dungeon/layout/structure-mask.json - Dungeon Layouts 
-   contribution/mobile/{lang}/tips.md - Tips for Mobile
-   contribution/mobile/{lang}/tutorial/\*.md - Tutorial
-   contribution/mobile/{lang}/procedural-names - equipment names
-   contribution/mobile/{lang}/item/lore - item lore
-   contribution/mobile/{lang}/scenario/\*\* - drop lore
-   contribution/mobile/{lang}/dungeon-lore/** - dungeon lore
-   tips.txt - Tips for desktop
-   tutorial/\* - Desktop Tutorial
-   contribution/lang/ - Localizations

**Remember to add your name to the ['Credits.md'](https://github.com/DexterHuang/CyberCodeOnline/blob/master/Credits.md) doc when you create a PR**

If you would like to help to maintain CyberCode Online, please feel free to submit a PR at [our GitHub repo](https://github.com/DexterHuang/CyberCodeOnline).

Step-by-step [Guide](https://cybercode-online.fandom.com/wiki/GitHub_PR_Tutorial) on how to submit a PR on our GitHub.



## Updates
### 2023/10/04
- Halloween update is active
  - AFK bot farm and enemies will drop jack-o-lanterns
  - Added pumpkin pie item, you can use it during combat to heal up large amount
  - You can trade your jack-o-lanterns with `Pumpkin Weirdo` for various rewards, including `Locked Legendary Container`, `Rare Equipment Crate` and `Pumpkin Pie`
- Updated gang notice UI, making it smaller and easier to see
- With the Techno thief event passed, we have decided to keep the mob around; they will keep spawning with adjusted drops for long-term balance.
- Fixes on some server stability issues

### 2023/09/22
### Spooky Character Design competition announcement!
Please see the discord announcement for more details :)
Please note that the Halloween update is still WIP, this is just competition event

Hello everyone! I am announcing the Spooky Character Design competition!

### rewards:
- **1st**: 1 epic DW cache + 1 employ case 
- **2nd**: 1 epic DW cache + 10 dora 
- **3rd**: 1 epic DW cache + 5 dora 
- **4th**: 1 epic DW cache + 5 dora 
- **5th**: 1 epic DW cache + 5 dora 
- **meme lord award**: free chocolate ice-cream emoji emblem and a congrats from your choosen mod 😉

### Topic
Halloween character! must be:
- Cyberpunk (duh)
- has a character
- Halloween/spooky themed

### Date
You can start submitting your art now! and the end date is the end of Oct 31st! I suggest you submit early to get more votes!

### What medium can I use?
You can use anything you like! draw with your hand, digital art, or even AI Image generation like Midjourney or Stable Diffusion! 

### How to join?
To enter the competition, simply post your art on the #character-design-challenge channel, the name of your character and background story if you like

### Rules
- SFW images only, if you post too revealing stuff we might need to remove it.
- No gore/racist/sexist or other obviously not okay stuff.

### How do we get the winners?
for people who do not join the competition or people who do, you can go the the channel to vote by clicking on "⬆️" on your favorite art (you can vote for multiple arts), and react with the 😂 emoji for the funny reward. 
I (Dexter) and the mod team will try to take into account your voting to decide the winners :D  (we will use only votes since people enter the competition at a different time so later enterer might receive fewer votes simply because it has fewer time to get votes)

### FAQ
#### Are you gonna use this in the game? 
No, its just for competition :D unless its really amazing I would contact you separately haha


- Backend code refactor and rewrite
- Updated filter list `queer` removed from the filter list, other game names to filter list
### Small notice:
I understand there are some rumors spreading revolving around "CCO2" or even "CCO closing down" due to some nonsensical reasons, I would like to take this opportunity to refute those rumors to avoid further misinformation:
  - **Is CCO2 coming soon?** No, there is no plan for CCO2 yet, it is also not WIP, I might make CCO2 in the future, but not yet, if I do I will ensure to keep the core of what makes CCO CCO and making it better, including chat focus, no-p2w, global buff, and others
  - **Are you making xxx to replace CCO?** No, if I am I would call it CCO2; The game(s) or App(s) I make (including games that some may already know and other games or Apps, like most programmers with the hobby of coding and trying new techs like AI and stuff, I do work on some other projects from time to time, and some might end up being released to the public, most may not, for example, I am also testing the idea of AI-generated RPG system for RPG games.), **these Apps or games, are not meant to "replace CCO" please do not worry. If I make CCO2 I will call it CCO2 and make sure it is worthy of the name and inherits what makes CCO CCO** 😄
  - **Are you gonna discontinue CCO?** No, there is no reason to discontinue CCO, as long as everything goes smoothly (like no some intentional sabotage attack on the game or something) and it is able to pay the server bills through the current donation system, there is no reason for me to close it down.
  - **Are you gonna change the monetization strategy of CCO?** No, the is no plan to do that, we have kept it for so long, that I think I would rather see it closing down due to lack of funding for server fees(which hopefully won't happen for a long time :D) than changing it to a P2W system for CCO. I hope if CCO closes down it would be because I make a CCO2 one day 😃
  - **Are you trying to make us play your xxxx game?** No, you are free to try any of my app or game out if you like of course, however for now, if I publish another App or game, I will try to make it as different as possible (no reason to make exact same stuff unless I am making CCO2), my intention is to differentiate as much as possible and try different style or technology like the recent craze of AI technology, (no PvP -> PvP, chat focused -> gameplay focused, minimal graphic -> more graphical elements, global buff -> standard mobile game model, more AI-generated content, etc etc), so for these reasons my other projects might not necessarily fit your taste or interest, especially if you are expecting a "CCO2" :) which is why I do not intend to advertise any of my other stuff here and might filter the names on CCO going forward just to avoid unnecessary weird rumors unless I think it will fit the community's taste and interest.
  - Please DO NOT spread rumors or misinformation, if you have concerns or questions please do just email me at ching.huang.dexter@gmail.com or DM me I will do my best to answer your questions.
### TLDR; Nothing is changing for CCO. Nothing is replacing CCO. unless I make CCO2 which may only happen in the future, not now. any other rumor you may hear is simply untrue.

### 2023/09/17
- Notification not working on Android is fixed, **please update the game from Playstore**

### 2023/09/14
- Minor UI fixes

### 2023/09/05
- Fixed issue with B3llial not showing up automatically correctly. now you can redeem stuff from him in the alleyway 
- Now Print & Sell allows the process of multiple types of cache, similar to how Recycler works now. this should benefit players who have small quantities but various types of cache to print & sell

  ![image](https://github.com/DexterHuang/CyberCodeOnline/assets/18545294/fe6b9f80-ef1a-48a2-9a61-9002338fe5f5)

- Added gang notice functionality, as leader or member with permission given by leader can send gang notice to all members with cost of BTC
  You can click the megaphone icon to send a notice, only members with permission will be able to see this icon. the effect is shown below.
  the notice will disappear in 1 day, and be aware that this will send a notification to gang members, however, there is a 7-hour cooldown on phone notification (to prevent people from spamming it to disturb other players), but you can update the notice as much as you want.
  
  ![image](https://github.com/DexterHuang/CyberCodeOnline/assets/18545294/e8057466-f849-4ef3-bb60-04039a60336f)
- Updated code for gang details page, now it would be updated more frequently (without requiring you to restart the whole game, might need to test for stability)
- Added a new Party Buff, for people who want to deploy 24-hour full buffs (AFK, EXP, BTC), when this buff is active, SL-Data Breach or included buffs cannot be deployed. this is an alternative to doing buff after buff manually for a long period of time.
 
![image](https://github.com/DexterHuang/CyberCodeOnline/assets/18545294/9375c0d2-54ed-49b0-9817-9beb5617a84e)
![image](https://github.com/DexterHuang/CyberCodeOnline/assets/18545294/3fd5445f-66da-4a02-a39d-0930f78518ea)

- Added new frame
- a bunch of optimization and clean-up on the server end.


### 2023/08/12
- Recycler is reworked; you can now recycle different types of caches at the same time, higher tier caches will produce better results. the main point of this update is to allow multiple types of items, useful when you have a small quantity of different types of things to recycle
- ![image](https://github.com/DexterHuang/CyberCodeOnline/assets/18545294/48345a4e-9959-41b7-99dc-aac69b759c3c)

### 2023/08/08
- co-op dungeon player movement should be fixed for now, still might be unstable, please let me know if it happens again. working on long term fixes

### 2023/08/04
- dungeon co-op movement is broken again, single-player dungeon should work as expecting,  working on fixing it 🐣

### 2023/08/03
- Fixed issues with real-time functionality such as dungeon player movement and others

### 2023/07/08
- Deployed patch that should fix chat server crashes/restarts issue

### 2023/07/06
- Updated chat filtering system, the AI that monitors for inappropriate messages should be less likely to have false positive classification

### 2023/07/02
- Added new `Rare Equipment Crate` similar to the locked legendary container but cannot be used together with RNG interferer, it has a small chance of dropping epic as well.
- You can get one free `Rare Equipment Crate` in `Arasaka Unit Exchange` every day, currently, the only way to get this item.
- Added `Tech Scrap Cluster`, so you can compress your tech scraps to save storage
- Added a new possible `healing multiplier` trait to upgrade modules. this will only drop in rare+ modules
- Added two new donator frames and emblem
- Backend rewrites and optimization

### 2023/06/20
- Improved bot detection 

### 2023/06/16
- Backend optimization and bug fixes

### 2023/06/06
- Updated npc's image to show less skin so its more acceptable in all cultures
- Updated backend and client for more stable chat (hopefully, still trying to find the cause for the unstable issue)
- Fixed issue with skip queue

### 2023/06/01
- Fixed issue with skip queue getting stuck in very rare condition
 
### 2023/05/22
- Updated dungeon quest with new UI, it will not show which gang member to defeat before accepting the quest

### 2023/05/20
- Increased chance of Techno Theif appearing when opening crates

### 2023/05/15
- Anniversary Update
- Techno Thief will spawn rarely in dungeon when you open crates, they drop better loots, including higher chance of epic items
- Gang dungeon will have chance to spawn a gang quest, involving killing enemies of specific npc gangs
- Added Dungeon token, you can use it to exchange items from Weapon Smith NPC, you can acquire this item from Techno Thief and Gang Quests
- Two new donator frames added

### 2023/05/04
- In market now the maximun selectable amount will be capped at how much space left in your inventory. thanks for player who made this suggestion on discord
- Adjuested npc `SLANC`'s personality base on community suggestion, the npc will now act more friendly. this npc is still experiemental please let me know how u think.
btw, this npc is not a tutorial bot and was not designed to be one, a AI-powered tutorial npc or helper would be cool but the tech is still not possible yet, it is still experimental. 

### 2023/04/22
- Fixed chat list with non-English UI would not show correct color base on player's title

### 2023/04/21
- Updated Friend list UI, now it shows your friends level and their names will be colored base on title
- Fixed issue with friend list, if some of your friend is missing in the list please add them back again.

### 2023/04/19
- Update core navigation framework, this should improve the tab switching performance by alot, should be more noticable on older mobile device, please let me know if you face any issue casued by this update
- Updated player list UI and fix some related bug
- Changed background music back to normal and free bundle removed after Retro Wave even is ended
- `Alley Way` is now hidden, `Bellial` will be back in November

### 2023/04/09
- Adjustment to `SLANC`, it should be more inclined to respond in the localized languge in channels (and from my testing performing better in non-english languages) and should be able to respond with longer sentences in non-english languages now

### 2023/04/08
- `SLANC Connector` is now available oon Arasaka Unit Exchange
- Multiple bug fixes for the new AI system
- Added new opensource tutorial markdown at /contribution/mobile/{lang}/tutorial/ai.md for detail steps and guilde to add custom community knowledge to AI system

### 2023/04/07
- Added `SLANC` AI, he is still under-development, this is part experiment with integrating the newest AI technology into the game and at same time to provide some entertainment value
- `SLANC` will occationally make remarks on player's chat message
- You can `Summon` SLANC for 10 minutes by using `SLANC Connector` item, this the bot is summon based and not available all the time because otherwise it will be too chaotic if its always chatting all the time,
functions similar to Chat Exploits, however it can be used at same time with Chat Exploit, the AI will also be affected by the Chat Exploit with different level of effectiveness,
from my testing Pirate, UwU and Love works well, with the AI trying to talk in that manner, so the effect is different from how it affacts players.
- SLANC will also have access to game knowlege in contribution/mobile/{lang}/tutorial/FAQ.md, and contribution/mobile/{lang}/ai/knowledge.md, you guys are welcome to add more stuff into the files, SLANC will automatically learn the knowledge once its been merged to github (with a few hours delay)
- SLANC is only available in Global, Mandarin, Korean and Japanese channel currently
 
### 2023/04/06
- Updated mod internal tooling to ensure better transparency, fair and friendly chat enviroment
- some wip framework for future updates 

### 2023/04/03
- Daily reward reworked, with many player's suggestion, now it will reset accroding to UTC date (UTC 00:00 instead of your local time-zone), instead of +24 hours of your last claim. should provide more predictiable schedule
- Daily reward page UI slight adjustment

### 2023/03/30
- Free legendary container given by B3llial is changed to random equpments because people were abusing it with alt accounts.

### 2023/03/29
- Added Tiago's chracter B3llial as an NPC, you can receive free items everyday from him, visit him at Alleyway in Market area,
B3llial will be available during March and September every year

### 2023/03/21
- You can now hide NPC images by toggling "hide npc" option in setting menu

### 2023/03/12
- Attempt to ease the issue with occupation points not registering correctly when there is a massive amount of people doing occupation tasks and finishing at the same time.
Please let me know if this issue has been reduced.
This issue is very tricky to mitigate with the current server architecture for technical reasons.

### 2023/03/08
- `Medical tech cluster` crafting price is now lowered from 50,000 to 5,000, this may be changed in the future.
- Now amount selection input will show the number keypad on iOS
- Security bug fixes
- stability improvement
- misc bug fixes

### 2023/03/05
- Fixed issue with BGM not playing on iOS

### 2023/03/02
#### Sythwave Update
- Added Medical Tech Cluster, which can be crafted with 1000 medical tech parts. this can be used to efficiently store a large amount of medical tech parts
- Added special item "Cassette Tape", when used you will receive buffs that give you +20% damage and +20% defence, the only way to get this item is a daily free bundle in Arasaka Unit Exchange
- Item details UI redesigned, now it highlights the primary button and secondary buttons have been changed to a smaller size
- Red envelopes will not drop anymore. Yen's shop will close on 16/03/2023, please use up your gold coins, otherwise, you won't be able to use them.

### 2023/02/21
- Fixed combat log not showing correctly on the desktop version
- Reduced difficulty on 500+ level enemies, both health and damage
- Minor UI fixes

### 2023/02/20
- You can now optionally hide lower level are in translations, this option will show up when you are level 30+
- Area now open to level 800
- Fixed issue with epic upgrade module shows that as if it can install a module but it can't
- Fixed bug where DexterHuang is showing on the leaderboard, I am not supposed to be in the leaderboard 

### 2023/02/17
- Reduced printing price for Epic items on higher levels
- Now top gang banner will again show in stations

### 2023/02/15
- Quick select will now not select bag items when selecting equipment, eventho its a equipment, considering people wont try to sell it, I have made it not to select it.
- Added ability to select upgrade modules in quick select module

### 2023/02/13
- Added quick select feature, now enabled only at sell to NPC shop interface, you can now configure what equipment or cache to be auto selected so you can sell them more quickly

### 2023/02/08
- You can now open chat tab on the left panel of web version, allowing you to see both gang and global chat at same time.
- Server optimization
- minor bug fixes

### 2023/02/03
- Added many new enemy images (thanks to `ZeFat` for creating the images)
- Added new BGM for gang headquarters (thanks to `D3C1M4L` for composing the track)
- Increased `Factory reset shard` max price at market
- Enabled equipment translation for Italian language 
- Changed skip heart image back to heart
- Fixed issue with login page cropped on some device
- Fixed issue with loading splash screen jumpy on some device
- Increased minigame reward, now has chance to drop `Rare Locked Container`

### 2023/01/28
- Bug fixes and optmization
- SL-Data fortress breach will be disabled for a day due to prevent overriding 1-day buff by `Raira`

### 2023/01/26
- Updated molecular print npc image
- Updated lee's image
- Show better login failed message

### 2023/01/25
- Updated clibration stiation npc image

### 2023/01/21
- Added trading system (still disabled & under testing)

![image](https://user-images.githubusercontent.com/18545294/213868294-9829d201-0f44-4a4e-b7c7-8065fcf2e9a2.png)
- Updated tranlation code, now there is way to make more text to be translated, will add more to translation config soon
- Fixed a bug where expired notifications does not get deleted, causing player data getting too big with expired notification and related security issue with expired notification still usable to join gangs from long time ago

### 2023/01/16
- Fixed issue with in rare situation where when navigating through pages back and forth too fast will result in app page get stucked in a invalid state.
- Reduced sensitivity of swipe on inventory tab
- Updated Judy's graphic
- Backend optimization and bug fixes

### 2023/01/12
- Fixed crash bug when openining gang permission popup

### 2023/01/12
- Updated rendering core liberary and with it added many optimizations, game should render faster both on start up and while running
- Updated graphic for Violet, Jen and Liam 

### 2023/01/09
- Added bot detection algorithm, server will detect base on client's behaviour and other factors to choose to show minigames when attempt to start AFK task ONLY IF the system think is necessary, meaning most people will not encounter this (*I am still tuning the system, the goal is majority(imagine something like 99%) of the player will not even encounter this mechanism, and the rare situation where the algorithm determine the client might be possible bot, the minigame/captcha will show up sometimes, not too often.*) this algorithm is also partly integrated Google's service to detect bots, which is base on Machine Learning and other Google magic, so it will become more accurate the longer we use it. hopefully this will reduce the number of bot abusers/cheaters and maintain the fairness of the game :)

### 2023/01/06
- Attempt in preventing two skips being used at exactly same time at very rare situation, let me know if it can still happen. 
- Serverside optimization, some part of system should run faster now and has less strain on the system overall

### 2023/01/04
- Fixed issue with some phone scales the UI way too big, now will force rescale the UI to more resonable scale. you can now also manually change your UI scale in setting
- Various backend bug fixes

### 2023/01/02
- Correction of typo on the previous update note, red envelop will drop 1 to 200 coins (*In game drop rate was not changed, just the update note has a typo*) 
- Improved the way Red Envelops are opened
- Fixed some issue with display scaling on some devices

### 2023/01/01
- Lunar New Year Event Update
  - Added new NPC Luna, you can find her in Yen's corner store in Market district, she sell 3 new items, `Rice Cake`, `Sushi` and `Dumplings`, additionaly she also sells `Legendary Locked Container`, all of which is changable with `Gold Coins`
  - Added new item `Red Envelop`, you can open it from your inventory to receive randome amount of `Gold Coins` range from 1 to 200 coins
  - Added bundle system, and 4 bundles, one of which can be claimed for free once a day
  - Added two new chat frames
  - Fixed several security issues
  - fixed market slot upgrade issue

### 2022/12/19
- Combat UI update
- Added global buff display in dungeon, and updated the UI
- security update

### 2022/12/16
- Fixed recycler not returning to main screen after starting task in pc mode

### 2022/12/15
- Added warning on AFK screen if device time is incorrect, as incorrect device time can often cause many display issue
- Added popup for incorrect time
- some bug fixes
- Added new bot prevention mesure 

### 2022/12/14
- Potential fix for in very rare case global buff item used will not deploy buff, only shows announcement 

### 2022/12/13
- fixed long suggested issue where people can gain advantage by opening multiple windows for same account at same time. now if a new client is connected to the same account, old client one will be disconnected to ensure fairness.
- fixed on certain sitiation pc version afk start does not work properly
- fixed pc version afk start does not return to main screen automatiocally
- fixed rare cases for pin not render properly 

### 2022/12/12
- Security bug fixes

### 2022/12/11
- Fixed crash issue when clicking send email button while email input is empty in password reset page.
- Multiple minor bug fixes

### 2022/12/8
- Increased `Locked Legendary Container`'s max selling price on market by 10x
- Added prompt for when device time is incorrect (if your device time is incorrect the buffs will not display correctly, there AFK task will not automatically finish correctly)

### 2022/12/6
- Fixed display issue on Russian fonts
- Fixed some issue with suspended account

### 2022/11/30 
- Winter update
  - During the event enemies and AI Core afk will drop `Mystery Contaienr` (not tradable), you can open it directly or combine 10 of them to craft a `Locked Legendary Container`
  - Updated crafting and other AFK task UI to use the new full page style
  - You can now view and activate EXP buff when afk task grands EXP as reward

![image](https://user-images.githubusercontent.com/18545294/204484585-6eda5a51-6d52-4413-8799-6dd3d294f7ee.png)

  - Shangri-la background image and skip like has been changed to winter theme

![image](https://user-images.githubusercontent.com/18545294/204484661-c9a7b6c0-a61a-4079-81e9-73d0afaa889b.png)

  - updated many background images in the game, including Commercial area, market, black market, weapons smith, calibration, and train satation
  - Updated amount selection UI you can now easily change the selected amount by increment of 10, and also select the max and minimun with one click

![image](https://user-images.githubusercontent.com/18545294/204483723-39b1a60a-8b10-4bcd-9c09-1e3927c617fd.png)

  - With the festive sprit, you can now send cosmetic (none-prestige donation tier and emblems) gift to your friends. *(Please do not use this feature for trading, it is for gifting with no return from your friends expected)*
  - Added two new limited edition chat frame and emblems, will not be purchasable after end of event (you will be able to keep using it of course)
  - Fixed rare cases where global buff does not show properly on client
  - other bug fixes
  
### 2022/11/26
- Optimization on skip speed, hopefully it will speed it up abit
- Server-side optimization

### 2022/11/20
- improved bot detection algorithm
- Security update

### 2022/11/18
- Added buff status display to recycle and black market
- Now when selecting a single item for black market and recycle, the game will prompt for confirmation before starting the task, avoiding mis-clicks
- Security update 

### 2022/11/16
- Fixed issue with using VPN not updating the client with status effect (a visual bug)
- Added Arial as a default fallback font for non-english langauges

### 2022/11/14 v0.780
- Added romania chat
- improved bot detection on backend
- sevrer optimization

### 2022/11/03 v0.780
- Fixed Halloween emblem not showing on cosmetic page after halloween even ended, now you can see it still if you own the emblem
- Fixed slder input not easy to click
- Added polish chat channel

### 2022/11/01 v0.780
- Added `Reward Booster Shard` buff for `AI Auto Farm` and `Scavange`, when buff is activated and opted in when starting the task, the rewards will double while the cost/duration will increase 4x. should be useful to do when going away for long time. this item will drop rarely in `Rare Locked container` and purchasable from NPC

*There might be balance change to this item if it is too OP, please use it immediatly after purchase*
- Updated AFK task start UI
- Level 500 ~ 600 is now enabled
- Added two new enemy images (thanks to Vali for the art ❤️)
- Added new CyberKitty chat frame (thanks to Volts for suggestion and idea)
- Added banner when chat exploit is active, so that newbies will understand whats going on
- love exploit words are now translatable :)

### 2022/10/28 v0.780
- Updated donation cosmetic UI to make it less confussing
- Updated alt detection algorithm

### 2022/10/26 v0.780
- Now people you blocked will not be able to send you gang invite
- Fixed some UI issue on craft page
- Fixed discord chat log search problem 

### 2022/10/24 v0.780
- Security update
- server-side bug fixes

### 2022/10/19 v0.780
- backend optimization

### 2022/10/16 v0.780
- Fix iOS overscroll weird behaviour on multiple page
- Fixed iOS mention popup placement issue
- Adjusted chat header UI

### 2022/10/15 v0.780
- Fixed iOS where is app is in background for long time and when resumed, dungeon and buff status will not sync up
- Changed dungeon keycode to use numebr keyboard by default

### 2022/10/11 v0.780
- Halloween Event:
  - Now enemies and AI Core auto farm drops `Jack o' Lanttern`, you can use these to craft `Locked Legendary Container`
  
  ![image](https://user-images.githubusercontent.com/18545294/195058830-f460e4c8-69b4-4543-916f-0c0aac79d00c.png)

  ![image](https://user-images.githubusercontent.com/18545294/195058984-6b79f9d0-295a-4f17-8ff9-50feb3279eec.png)

  - Updated pormotional popup screen to support multiple pannel and translation
  - Added time Halloween time limited cyber-bat donation tier and a Spooky smile enmblem (unobtainable when event is over)

### 2022/10/07 v0.780
- Removed auto default selection for unlock container page, to reduce confusions on how to select container to unlock

### 2022/10/02 v0.780
- Updated Item selection menu UI when there is no available item to choose from
- Added dedicated unlock `locked container` UI

![image](https://user-images.githubusercontent.com/18545294/193444573-24ae96c4-6c74-45b2-a13b-6f0f7031d6e6.png)

- You may now click `Unlock` in locked container detail screen to go to unlock container UI
![image](https://user-images.githubusercontent.com/18545294/193444654-3123ec82-6388-4f84-8432-692c59751fc6.png)

### 2022/09/30 v0.780
- Added seperated chat log for spanish channel
- Added more translatable text to translation files
- Fixed translation issue

### 2022/09/26 v0.780
- You can now browse your stall while afk, however you cannot add or remove the item while AFKing. (player suggestion)

![image](https://user-images.githubusercontent.com/18545294/192716779-aafe7489-0651-4018-84d6-66346536fb6e.png)

- Added player submitted emblemed I missed from last patch
- Added foundation code for event needed function for future use

### 2022/09/26 v0.780
- Server optimization
- Chat related bug fixes
- Added some player submmited emblems 
- Typo fix

### 2022/09/19 v0.780
- Market security related fix
- Now only tradable item will show up in the selection list for market stall
- Desktop version can now have switch the chat pannel bewteen mail/global/mail
- Fixed broken item texture when the game starts in deskop
- Adjusted chat channel settings
- Minor UI improvement for desktop

### 2022/09/16 v0.780
- (from player suggestion) Starting new AI core farm task will default at max amount of repeat you can perform
- Updated Tutorial menu page, now with cleaner button and icons
- Updated Tutorial markdown page, and fixed some display issue.
- Updated printing npc UI
- Added more newbie friendly tip box on molecular printing page, uppon clicked will link to tutorial page
- Added tip box in clibation page before core was inserted, uppon clicked will link to tutorial page
- Reduced section title size a little
- Added graffiti and bunny prestige donation tier (Thanks to Krolik for design suggestion and happy birthday :) )

![image](https://user-images.githubusercontent.com/18545294/190539431-7112e0d7-4741-4c42-931a-37424d4f312f.png)
![image](https://user-images.githubusercontent.com/18545294/190539403-86d8a35b-c9f7-44e1-abf9-d4e1e9288dd4.png)


### 2022/09/13 v0.780
- You can now click `Print Cache` in cache item details own by you. it will bring you directly to NPC and highlight the coresponding cache to print.
- Added translation for gang creation page 

### 2022/09/03 v0.780
- Updated City center, train station and bank's background image to better ones
- Updated location background display UI

### 2022/08/29 v0.780
- Added report menue, you may report rule breaking player by clicking on the message or report button at the player's profile 

**Only use if necessary and only once per player. If you play/spam/missuse with the system, you will be muted for spam**

### 2022/08/26 v0.780
- Added some preventive mesure to reduce the chance of unwanted deploying of global buff when another player has alraedy deployed one:
  - When deploying a buff with an active buff and the buff is has more than 19 minutes remaining, the deployment will fail forcefully, you may deploy again after 1 minute if thats what you wish (might still have extremly rare chance of two person clicked at the exact same millisecond result in server unable to prevent it)
  - When deploying a buff with an active buff and the buff has more than half of the time remaining, a popup confirmation will popup show up. (this only applies to buff that has duration of 20 minutes and for `Frontal Cortex Optimization Transmitter` and `Rare Synaptic Acceleration Transmitter` only when buff is fully stacked, and will not work if you are desync from server due to network connection issue)

### 2022/08/24 v0.780
- Fixed Thai chat channel typo in the name

### 2022/08/23 v0.780
- Added Thai chat channel

### 2022/08/18 v0.780
- Merged latest english procedural-name.json list from githhub into the game
- Updated black market art, sorry @mikazakhaev if its not 100% true to your original design haha  
- Server-side bug fixes

### 2022/08/17 v0.780
- Prevent the annoying suggestion/auto complete from showing up on PC browser when typing on chat

### 2022/08/10 v0.780
- Fixed prestigue nano medic drone translation not showing in translation
- Showing numeric keyboard when doing captcha

### 2022/08/09 v0.780
- Updated tran station and market background image to something original
- Optimizations and bug fixes

### 2022/08/06 v0.780
- Fixed issue with mail chat
- Fixed issue with reverse ai core cluster crafting could result in item exceeding max stack (system will in some condition reset items with amount more than stack to it is stack cap, meaning if you somehow find a exploit to allow exceeding max stack, please do not risk system resetting your item amount, report the bug to me <3)

### 2022/08/05 v0.780
- Fixed bug where when viewing other player's item will result in app freeze 
- Fixed issue with item details page where when item is scrapped the page stays as empty, now it automatically exits the page

### 2022/08/04 v0.780
- Chat server internal update, should help with stability

### 2022/08/03 v0.780
- Updated server and client side dependency liberaries, might improve client side performance, please let me know if new bug is introduced due to this update
- Improved range select input user friendliness

### 2022/08/02 v0.780
- Improved range select input user friendliness (delayed due to deployment issue)
