# Update Notes

If you found a bug please post a bug report in our [Discord server](https://discord.gg/gnCgBBCgeh) Bug report channel.

Did you like the game and fancy helping the game? you can:

- Leave a 5-star review on the store. This will help others see the game more
- Report bugs or suggestions for improvement to our Discord; the developer checks Discord frequently (due to time limitations, I can't really check Reddit or other places)
- Deploy some global buff or skips for the community
- Contribute to our WIKI, Lores and other configs on our [GitHub](https://github.com/DexterHuang/CyberCodeOnlin

## Upcoming Update Notice

**Feedback and suggestions are welcome**
Please send your feedback to my Discord or email me directly.

## Updates

### 0.1885

**Christmas Event**:

- During the event, FrostByte Shard will have a chance to drop from AFK bot farm and enemies
- You can exchange FrostByte Shard with CyberSanta for various items
- During the event, top-ups will receive bonus items
- Added new Christmas-themed chat frames and emblems
- **Christmas Workshop Event Game**:
  - Added new event game where you sort gifts to correct zones across 5 progressive stages
  - Each stage increases in difficulty with more gifts and faster pace
  - Complete all stages for maximum rewards
  - Requires Santa's Workshop Pass to play (obtainable during Christmas event)
  - Access the game from CyberSanta at Market Street
  - Added Santa's Workshop Pass item
  - FrostByte Shard is now tradable
  - Added Skip Discount Ticket exchange option at CyberSanta
- **Jukebox System**:
  - Reworked personal jukebox player (Walkman mode) - select background music to play everywhere you go
  - Added apartment jukebox (Home Speaker mode) - set background music that plays for visitors in your apartment
  - Override mode allows your personal selection to override location-based music
  - Access jukebox from apartment page or settings menu
- **Apartment Wall Feature**:

  - Players can now post notes on other players' apartment walls
  - Requires Friendship Sticker item to post notes, they can currently be obtained from dungeon
  - Apartment owners can enable/disable wall feature in settings
  - We only allow friendly notes to be posted to prevent abuse
  - View recent notes posted by visitors on your apartment wall

- Added new Relay Grid minigame with drag and touch support
- Added new Hex Buffer minigame - follow the sequence of hex codes by alternating between rows and columns
- Added Candycane chat frame
- Updated several images for locations
- Added some NPC animation
- Enhanced video rendering performance with WebGL support
- Reworked location display UI
- Updated train station background image
- Updated mail list UI
- **Added some features from player suggestions**:
  - Show player buffs to AFK start pages
  - Made `Tech Scrap Cluster` shown as yellow in crafting option
  - Added new icons for Event, furniture and consumable items
  - Added filter by Event, Furniture and Consumable items in inventory page

### 0.1884

- **Furniture System** (Level 300+ required):

  - Added late-game collectible furniture system that additionally provides minor stat bonuses to players when activated, **furniture stats stacks even in the same category**
  - Craft furniture using progressive Assembly Kit system (Basic → Advanced → High-End)
  - Trade Assembly Kits with `Miles` the Furniture Vendor NPC at `Crystal Sands` for specific furniture
  - Activate furniture using `Energy Cells` obtained from AFK tasks
  - Gather furniture materials from `Crystal Sands` AFK tasks (`Salvage Beached Tech Cargo` and `Salvage Power Units`)
  - For detailed information, please refer to the furniture tutorial page

**PLEASE NOTE: As this is a new feature, things may change in the future as we gather more feedback, Please feel free to provide your feedback to my Discord DM or email me directly at ching.huang.dexter@gmail.com.**

- **Apartment Updates**:

  - Reworked apartment UI for better user experience
  - Added new apartment tier with more furniture slots

- **Thanksgiving Event**
  - Scavenging and AFK bot farm will drop `Roasted Turkey` rarely
  - Consuming `Roasted Turkey` gives +20% AFK EXP boost for 20 minutes
  - Party contribution receives up to 10% discount for early contributors
  - During the event, top-ups will receive bonus `Rare Synaptic Acceleration Transmitter`
  - **ALL** Event items will expire when event ends

### 0.1883

- I _May_ have found the issue that causes in very rare cases some enemy has abnormally high damage and one-shots players in dungeon. Please let me know if any of you encounter the same issue again, hopefully we have fixed the problem now 🤞

- Minor UI tweak; reduced the size of original text in message when translated to reduce the space taken by the message

### 0.1882

- Halloween Event (10/01 to 10/31):

  - Enemies and AFK bot farms will drop `Pumpkin Bro's Seed` which you can exchange for various rewards with `Pumpkin Bro` at the Alleyway in Market Street, event based item will expire when event ends
  - `Pumpkin Bro's Seed` are tradable between players and can be exchanged for several items
  - Added `Caramel Apple` provides a 10% boost to AFK EXP and BTC gains for 20 minutes, expires when event ends
  - Added `Pumpkin Bro's Lollipop` provides a 20% damage boost for 10 minutes, expires when event ends
  - Halloween-themed chat frames and emblems are available during the event

- Added translation support to gang chat channels
- **Note**: Due to expected higher usage of the translation service, plus we changed the serviced provider, it may be unstable. Please let me know at ching.huang.dexter@gmail.com if you experience any issues

- As suggested by the community, tutorial quest at the quest tab will now be hidden for player higher than level 100

- **Display Shelf System**:

  - Added display shelf functionality - players can now display up to 3 items on their profile for other players to see
  - Display shelves are visible to all players and any player can customize their own display shelf
  - Display shelf slots now unlock progressively based on level and BTC requirements
  - This feature allows players to showcase their favorite equipment and inventory items

- **Epic Equipment Exchange System Rework**:
  - Instead of Extraction requiring buff activation, now we moved the buff requirement to Fragment Fusion instead. this way you can convert unwanted epic equipments into fragments at any time.
  - This is great for inventory management - you can now easily convert unwanted epic equipments into fragments to save inventory slots without having to activate the buff
  - Improved the Epic Cache Fragment drop rates from equipment extraction

### 0.1881

- Free chat buff is disabled due to issues reported by the community, I will be adjusting and re-enabling it in the future

### 0.1880

- The free random chat buffs are back! Sorry for the long wait. Due to previous gameplay updates, this feature had to be rewritten from scratch. now there is a new special UI for when a free random chat buff is deployed

### 0.1879

- **Marriage System**:
  Long-requested marriage system is finally here! Marriage system is a cosmetic/roleplay feature; it allows two players to be married to each other and requires both players to agree to the marriage.
  it allows two players to show off their partnership as a custom marriage banner and vow phrase in both chat pop-up and player profile.

<img width="388" height="354" alt="image" src="https://github.com/user-attachments/assets/02a1d70e-7f08-4b9e-90a1-f322a178245a" />

- Propose to other players using wedding rings (available for purchase in-game)
- Create custom marriage banners with:
  - Romantic symbols and heart emojis
  - Custom background images (ultra-wide 2:1 ratio recommended)
  - Personal vow phrases (up to 64 characters)
- Marriage contracts with expiry dates that can be extended using Rose Bouquet gifts to your partner.
- Marriage extensions trigger global chat announcements celebrating enduring love
- Access marriage settings through player profiles for customisation
- Either partner can end the marriage at any time
  For detailed information, please refer to the marriage tutorial page.

❓ Why not include gameplay features like shared apartment/vault or others?

- The main reason to keep this feature cosmetic and roplay focused is that I want to stay commited to cosmetic/paid content to have a little gameplay effect as possible, to keep the game non-pay to win.

**Feedback and suggestion are welcome :) please send your feedback to my Discord or email directly.**

### 0.1878

- B3llial will show up in Alleyway during September, you can redeem `Cassette Tape` and equipments from him, `Cassette Tape` WILL expire after September 30th, so be sure to use it before then.
- with player feedback, we have increased `Ammunition tech parts`, `Ammunition tech parts cluster`, `Military ammunition tech parts` and `Military ammunition tech parts cluster` max sell price on market.
- with player feedback, `Fragment Extraction`'s `Epic Cache Fragment` drop rate is increassed.
- Optimization and bug fixes regarding to NPC animation
- Added new `Neon Elite` donation frame

- September Event (09/01 to 09/30):
  - During event top-ups will receive various bonus items

### 0.1877

- Added capability to animate NPCs

### 0.1876

Epic Equipment Exchange (Subject to change and player feedback):

- You can exchange 4 Epic Equipments to random amount of `Epic Cache Fragment`s base on random chances, currently set to from lowest 1 `Epic Cache Fragment` to highest 6 `Epic Cache Fragment`s (this is subjected to change base on feedback and testing)
- You can exchange 8 `Epic Cache Fragment` to 1 random Epic Equipment Cache
- The exchange will need to be activated with a global buff, this is to eliminate the worry of sudden influx of new epic cache into the market; this will slow down the rate of exchange, to reduce the shock to the market.

**Why?**
This is to address two frequently player requested features:

- Allowing players to change unwanted epic equipment cache type to other type
- Allowing players to exchange "bad epic rolls" to try again

Additionally, in the long term, this will:

- Reduce the amount of Epic Caches and Equipments in the market and encourages trade
- All exchanges will be less than 4 to 1 rate, so net amount of Epic Caches and Equipments will be reduced
- Introduce additional use for epic equipments that is unwanted for whatever reason deem as "bad epic rolls"
- caches of unwanted type can be printed then exchanged to become another type of cache
- Encourage buying of any type of epic cache since they now can be used in other way

### 0.1875

- Multiple bug fixes
- preparation for upcoming update
- Summer event is extended to the end of August

### 0.1874

- Added JukeBox in apartment, you can now select a background music in your apartment and have it as the overriding background music no matter the location you are at. this can be disabled in the settings menu.
- Added option to adjust background music volume in the settings menu

### 0.1873

![image](https://github.com/user-attachments/assets/16df503a-a0ec-431d-80b4-c15d84dd12fa)

- Summer Event (July 1st to July 31st - May be extended depending on situation):
  - During the event, `Sea Shells` will have a chance to drop from AFK Bot Farms, Scavenging activities, and Loot Crates. You can exchange `Sea Shells` with Josie at Crystal Beach for various items.
  - `Sea Shells` are tradable between players, and are time-limited only during the event
  - Calibration contributions will have up to a 5% discount for early contributors.
  - A "Summer Bonus" is active for top-ups, granting bonus items.
- Fixed issue with sometimes when the event has ended, the event item still drops until server manual restart
- Fixed issue with chat
- Added new chat frame `NEON ELITE`

![image](https://github.com/user-attachments/assets/2ad9b33a-68aa-47ea-a706-be7e7845930a)

### 0.1872

- Added new Elite or above donator feature, you can now send image to players who has added you as friend; You can only send image to players that has added you as friend, you adding them as friend will does not count. this is to prevent people from sending unwanted images.
  there is a limit for how many images you can send in a period, it is subject to change depending on situation such.
  Images received will be shown as blurred, and when clicked the image will be revealed. this is a additional safety feature to allow you not to see the image if you do not want to.
  **IMPORTANT: The image sent is NOT encrypted and NOT secure, DO NOT send sensitive images**
  **If someone is sending you image you do not want to receive, simply remove them from your friend list**

- Fixed translation error in market transaction mail

### 0.1871

- Fixed issue when translation fails sometimes the messages shows `[Object Object]` instead of falling back to original message
- Fix leaderboard UI issue where the value is not aligned correctly
- Several Optimization

### 0.1870

- Added auto-translation to Global Channel, now all messages sent to Global will be automatically translated to:
  - English
  - Chinese
  - Japanese
  - Korean
  - Bahasa Indonesia

If your UI language is listed above, you should see all messages translated to your language, for other languages you will see translated messages in English instead (if its not already in English)

The translated message would contain the translated text on top and the original text below:

![image](https://github.com/user-attachments/assets/19344c51-e5cd-40ec-94af-6a500617e232)

You can disable showing the original message or disable the entire auto-translation feature in the settings menu.

![image](https://github.com/user-attachments/assets/23f14c50-7c1a-41da-b813-89bdc48e8f3b)

- During June, we are experimenting with a new event type where you can get event items just by chatting in Global; basically every 15 minutes if you chat in Global there is a random chance to get a event item, during cooldown, no matter how many message you sent, you will not gain chance to get event item.
  **Spamming will automatically exclude you from the event, and will NOT increase your chance to get the item at all due to the 15-minute cooldown**
  **The best way to participate is just to chat normally**
  **I may adjust the cooldown time based on situation if needed**

![image](https://github.com/user-attachments/assets/ddb6cff6-1436-4627-90f6-6eb9ea9aa530)

- Added new chat frame `Aurora`

![image](https://github.com/user-attachments/assets/50311541-d4fc-48e0-9336-da1851557e35)

### 0.1869

- **Fixed Gifting Network Errors**: Resolved an issue where gifting items to other players occasionally resulted in a `Network Error`. The root cause has been identified and optimized to prevent recurrence.

You should now experience faster and more reliable gifting transactions.

**Pro Tip for Valuable Transactions**:  
To ensure a successful gifting process for high-value items, consider sending a small, low-value item first. This initial transaction caches data, significantly reducing the likelihood of failure for subsequent valuable items. Even if a network error occurs, your valuable item will remain secure.

### 0.1868

- In this update we have added several player suggested features:
  - Loadout presets - You can now save equipment loadout for quick switch between different loadouts saving you the hassle of manually swapping equipment every time you want to switch loadout, for more information please refer to the tutorial page
  - Fixed issue with Epic Upgrade module display issue in item details page where it shows a slot for module but its impossible to have module slot for upgrade modules
  - Attempt to fix issue with gang chat notification sending to player who has already left the gang,if you still face this issue please contact me or a moderator to notify me
- You can now see other player's donation frame and emblem list in their assets tab, if you do not wish to show yours, you can disable it in the settings menu

### 0.1867

- Quality of Life Update: with most suggested by players and the long awaited, one of the most asked and reuqested, the Ammo Tech Parts Cluster and Military Ammo Tech Parts Cluster is added, you can craft them similar to other clusters, sorry for the long wait since I first promised to add these items!

### 0.1866

- Sakura event: (2025/03/01 to 2025/03/31)
  - Sakura frame and other emblems are now available during the event
  - during event there will be discount on party and calibration contribution, the earlier contribution will get higher discount
- Added several minigames

**NOTE: the frequency of the minigame showing up is NOT increase nor changed, the only thing changed is instead of getting the same minigame everytime, there will be other minigames. again, the chance/amount/frequency of minigame showing is NOT changed**

**The new minigames are new, so if you face any bugs please do report it on our discord channel or if its urgent email me or contact a moderator to notify me**

- Memory Bank Override - simply click the light-up blocks, if you forgot just click `verify pattern` it will show you again

![image](https://github.com/user-attachments/assets/ba1a5089-3d01-4aeb-8cde-620c6546796a)

- Data Stream Interceptor - just click the yellow thingy

![image](https://github.com/user-attachments/assets/fdb60f38-9c91-4fa5-b3a4-438bd34fea1b)

- Decrypt Neural Data - just click the symbol that is shown to you

![image](https://github.com/user-attachments/assets/8588462a-85d7-4c3b-92a9-a2a3ab080fe3)

- Neural Circuit Override - click the nodes in sequence shown at begining, if you forget you can just keep clicking to see the correct sequence

![image](https://github.com/user-attachments/assets/641c6dfe-c632-4ad7-aa37-9ee1010631ff)

- Added new frame `Cyberpunk`

![image](https://github.com/user-attachments/assets/d58c6192-fbcb-4b9f-858f-b546e0d1df32)

### 0.1865

- Valentine's Event (02/05 ~ 02/28):
- `Chocolate Strawberry` and `Heart Shaped Chocolate` will drop from both AFK bot farm and enemies, `Heart Shaped Chocolate` increases AFK EXP by 20% for 10 minutes, `Chocolate Strawberry` increases both EXP and BTC received in AFK tasks by 10% for 10 minutes
- Both `Chocolate Strawberry` and `Heart Shaped Chocolate` are giftable, and are time-limited only during the event
- During the event, all AFK skips are 5% OFF on unit spend
- Added Valentine-themed donation frame, this frame can be gifted to another player for 1 month period with a lower amount of unit

![image](https://github.com/user-attachments/assets/74d23a12-4f97-4544-84f3-6911bace97ab)

- Fixed issue with sakura frame blocking player's name

### 0.1864

- During Luna New Year 01/29 ~ 02/04, added a special 8% discount to all units for skips
- Added sorting to gang member listing, you can now sort by occupation, resource, money or EXP

![image](https://github.com/user-attachments/assets/2e43a9b7-6972-4d16-88ba-d5e0313bb970)

- The apartment page now shows the next rental due date
- Many small UI tweaks and bug fixes

### 0.1863

- Fixed gang chat notification, previously it did not send notifications even when the setting was turned on, now it should work.
  for whom does not want to receive notifications for gang chat, you can disable it in the settings menu or simply click on the bell icon in gang chat:

  ![image](https://github.com/user-attachments/assets/b5e62089-a92b-4df7-b84e-39f3641f8f02)

  ![image](https://github.com/user-attachments/assets/5812e87f-b4b8-40d0-9209-df673769d565)

- Many UI improvements for certain devices, mainly China branded Android phone
- Fixed incorrect random minigame interaction with certain AFK tasks, only affected Recycling and Print & Sell

### 0.1862

- The Lunar New Year event starts today, and till the end of January. during this event:
  - AFK bot farm and enemy will drop `Red Envelops`, and you can open them to receive `Gold Coins`, `Gold Coins` can be used to exchange for event specific items from `Luna` located at Market Street. event specific items will be automatically removed at the end of event so be sure to redeem and use the items. (`Gold Coins`, `Roasted Turkey`, `Sushi`, `Rice Cake`, `Dumplings` and `Red Envelops` from last year will be automatically update and merge to this year's version and can be used as normal before getting expired at the end of event period)
  - During the event, top-up units will receive various bonus items

### 0.1861

- Added option to enable/disable drag-to-reply for messages on web version

### 0.1860

- Fixed issue with notification not working on PC web version, now if you allow notification you should be able to receive notification even when the Cybercode Online tab is closed
- Added in-game notification sound when mentioned or received mail, this can be disabled in setting menu

### 0.1859

- Fixed the send mail button on chat message popup
- Updated Android app, fixed issue with bottom nav bar showing white or other incorrect color, if you have this problem this needs to be updated from PlayStore
- Fixed issue with notification not working for newly installed user
- General optimization
- Fixed issue with non-English equipment name loading problem
- Fixed minor UI issues introduced by previous UI scaling update

### 0.1858

- Added a new UI scaling method, which should produce more consistent rendering regardless of device font size and other settings
- Added gang banner display when clicking on player's message

### 0.1857

- Buffed Santa just got buffed, with some player's feedback onthe low drop rate of `FrostByte Shard`, the drop rate has been increased
- CyberSanta now also exchanges `Overclock Creatine`, when used your damage will increase by 5% for 20 minutes

### 0.1856

- increased hash processor max price at the market with a suggestion by the community

### 0.1855

- Christmas Event:
  - Dungeon chest and AFK Bot Farm will now drop `FrostByte Shard` which you can exchange various items with `CyberSanta`
  - You can exchange `Jolly Gains Chest`, `Pure Whey Gainz` and `NanoNibble Ball` with `CyberSanta`
  - The `Jolly Gains Chest` can be opened similarly to other containers, from the terminal or directly in the item details screen.
  - When `Pure Whey Gainz` is used you will gain +20% AFK EXP
  - The Christmas-themed donation frame is in rotation
- Several bug fixes

### 0.1854

- During November Turkey will rarely drop from the scavenge end AFK bot farm,
- Fixed issue with minigames appearing too often, now it should behave better
- Fixed pet ageing issue, it seems like the last update didn't completely fix the problem, I found another issue that may cause the age to drift, this should fix the problem now 🤞
- Tutorial will not show up on players who are higher level than 20, this is so that some people who for any reason always got their cache cleared won't need to see tutorial every time, while this is added, I would like to add, clearing cache does NOT improve speed for your device, cache saves battery life, reduce data usage and speed up your device; that is the primary function of caches

### 0.1852

- Fixed issue with incorrect animation shown when the player dies (previously, the enemy's health went to zero falsely leading to confusion)
- Fixed issue where sometimes when the app is awakened from sleep on a page that is not the main page, the game will show a blank screen when clicked back.
- Now when the player dies, the animation of health going to zero will be played instead of immediately going to the death screen
- Added new notification request popup
- Optimized app loading reducing process needed and files loaded
- Fixed issue on pc where at times, the item icon shows a square instead of the actual icon while doubling the resolution of the icons
- slight UI change on item popup on equipped item
- Updated tutorial
- Fixed issue with iOS notification

### 0.1851

- Enemy images are completely redone, and now include around 800 higher-quality images

### 0.1850

- You can now drag messages to the right to reply to the player quickly in the chat interface

### 0.1849

- Combat code is re-written to allow showing enemies with zero health when they die before switching screen back, it previously was cut off and many players reported it feeling very odd and unnatural

### 0.1848

- Added new BGMs, and replaced some of the old ones
- Optimization; the game should load faster compared to before

### 0.1847

- Halloween Event (Will activate at 2024/10/01 00:00 UTC)
  - Enemies and AFK bot farm will drop `Jack o Lantern` you can use it to redeem items from `Pumpkin Bro` in the Alleyway on Market Street, items that can be redeemed includes `Locked Legendary Container`, `Rare Equipment Crate`, `Pumpkin pie` and `Caramel Apple`
  - Added `Caramel Apple` you can redeem it from `Pumpkin Bro`, and use to receive a 10% AFK exp and all Btc gained buff for 20 minutes

![image](https://github.com/user-attachments/assets/e122f006-fd01-4b58-b321-ef9720d30048)

- Added `Replicator Console` to dungeons; in dungeons `Replicator Console` will randomly spawn, you can gather `Synthetic Alloy` from boss room crates to activate them to receive random rewards. there are 4 tiers of `Replicator Console` each tier requires more `Synthetic Alloy` to activate, at the same time gives better buffs and rewards, but also has a higher rate of failing.
  When failed, the `Replicator Console` will consume the `Synthetic Alloy` inserted. The reward includes various equipment and buffs from different tiers.

![image](https://github.com/user-attachments/assets/739ffea6-9964-46ae-bf4b-d4d6b2c06cee)

Please notify me if there is any bug with the updates 🫡🫡

### 0.1846

- Fixed pet age display issue, after Looooong search and many attempts trying to find why the leaderboard sometimes displays incorrect age for pets, I finally found a potential fix for it, the pet's age should display correctly now, and the calculation of age is more complicated then one may think due to various technical reasons, which causes it to be hard to track and display the age. hopefully, this fixes the issue, please report back to me if a similar issue continues to happen in the future :)
  Please keep in mind that leaderboard data is not real-time and delayed meaning the age you see there are not necessarily the same as how the owner sees it, for pet age, it's possible for the ranking to be lightly out of order in rare cases due to technical reasons.
  additionally, the leaderboard page UI is updated

![image](https://github.com/user-attachments/assets/51acfa12-b945-445f-bc77-87cb58604704)

- Fixed emblem pricing display incorrectly for limited edition emblems (such as emblems only available during event or special emblems like translator emblem) on sending cosmetic page, previously, an incorrect price of "999999" was displayed on unavailable emblems, now no longer is the case
- Rewritten how the emblem list is displayed, all unavailable will show up in the list but has a `Unavailable` tag

![image](https://github.com/user-attachments/assets/32cca6f2-2b6d-4c32-9169-d45f99f1a50a)

### 0.1845

- Added new tier of backpack: `Quantum Storage Unit` similar to other backpack items, increases inventory slot drastically, this also serves as an optional late-game goal and a token to show off your wealth and standout against other players, You will also receive a backpack emblem for free when you crafted this item. **Given the item is a long-term collectable goal, we do not expect people to craft it any time soon, the exact requirement to craft this item is Subject to Change and is NOT FINAL, and we are open to lowering the crafting requirement based on the situation, and feedback or suggestions are welcome :) drop me a message on Discord or email**

![Screenshot 2024-09-26 023050](https://github.com/user-attachments/assets/6b39d107-d151-47f6-b682-e8f013c4821c)

- Game server backend engine is updated to the latest version, things should run faster and smoother

### 0.1844

- Added dungeon chat channel, you can communicate with your dungeon party in that channel without using a gang channel that may disturb others. You can open the chat UI by clicking the preview. All share this channel, which can be viewed similarly to other channels on the main chat interface.

![image](https://github.com/user-attachments/assets/2a598a00-32a9-4e4a-a7f0-6b002387fa10)

### 0.1843

- You can now see gang dungeons created by people from your gang in the dungeon list (access it from the phone menu -> dungeon list)
- Added dungeon lobby list at create dungeon UI allowing easier access to join dungeons

![image](https://github.com/user-attachments/assets/fa585ee5-1ef4-4754-a0c7-5ba27461fe0e)

- Updated main page NPC and travel UI

![image](https://github.com/user-attachments/assets/7a2495ae-5e6b-405e-bfe0-01a31c9cae64)

- Fix the issue with chat frame rendering
- Added update popup when starting the game, if the update note is updated, a popup of the update note will automatically show up (Can be disabled on the settings page)
- Changed behaviour on event popup, popup will show up again after 4 days to avoid the event list not being accessible after dismissal, this behaviour can be disabled in the settings page, which if enabled event popup will show up only when there is an event update if you have checked the dismissal checkbox

### 0.1842

- Fixed issue with some notification not receiving randomly
- Updated image for weapons smith and lee

### 0.1841

- Updated Global party and Cali Train banner UI, now shows player tag and how many percentages the player has sponsored

![image](https://github.com/user-attachments/assets/0e0b6119-2568-42da-b6c6-04258f706cbe)

- Added Vault shortcut in AFK screen, allowing you to view your vault content, however, you cannot withdraw or put the item.

![image](https://github.com/user-attachments/assets/7f0f2a00-e5e6-4804-97d9-2f6ca550096a)

- Fixed issue with AFK countdown number changes causing layout shift
- Updated leaderboard UI
- Server-side fixes that are aimed to reduce the chance of a "locked up" issue in the dungeon (the error message -> "Failed to lock ....")

### 0.1840

- Summer Event (August):
  - Added `Coastal Area` and `Crystal Sands` Beach, where `Josie` is, this location will be hidden after the event ends, level required to enter this area is level 15
  - scavenge, AFK farm bots and dungeon crates will have a chance to drop `Sea Shell`, you can exchange `Sea Shell` for various items in the with `Josie` at the newly added location
  - During this even, all community contribution buffs (cali & party) will have up to 5% discount for early contributors, the discount is the follows from the first to the last contribution:

1.  5%
2.  5%
3.  5%
4.  5%
5.  5%
6.  2.5%
7.  2.5%
8.  2.5%
9.  0%
10. 0%
    - Added beach themed new chat frame

![image](https://github.com/user-attachments/assets/1f5af351-9c6b-4817-84e6-40135989fbf5)

![image](https://github.com/user-attachments/assets/f238f08d-3d9c-4f77-8ce8-41fefe4b51d4)

![image](https://github.com/user-attachments/assets/65b79fd9-fee3-479a-8a15-a8d98c0ccba8)

![image](https://github.com/user-attachments/assets/3369cb9b-b17b-48bc-88f9-fb1541641025)

### 0.1839

- Calibration Rework/Code Re-write:

  - A new line of community fundraising with different starting time of cali train will be added; there will be two fundraising options, one will start at 00:00 UTC and the other will start at 12:00 UTC, the two funds will be independent of each other. The intention is to give people more options to choose which fund to raise depending on their preferred schedule while providing a predictable timing. the current funding will carry on to the 00:00 UTC fund, and the 12:00 UTC fund will start from 0% when the update is live.
    ![image](https://github.com/DexterHuang/CyberCodeOnline/assets/18545294/9736f045-d6b6-48d5-a0fe-649e8ee3100c)

    _Note the image says 8am and 8pm because my timezone is UTC+8, it will show up differently according to your device timezone_

  - **The System will allow normal calibration buffs to be deployed even when there is a pending train**, until a short time before the train starts, to prevent it from interfering with the event train
  - 8 hours before any Cali Train starts, a banner will be shown on the chat screen, similar to Party Funds, to remind players of the upcoming train.
  - With the new system deploying calibration buffs will no longer require using of an item, the functionality will be integrated directly into the Calibration NPC UI Page (Kamiko), hence all calibration-related items will be retired from the game; **All Calibration related items will remain usable as normal if you already have them in your inventory before the update**, and they will no longer be obtainable from any source after the update. This is to simplify the user experience, reduce the complexity of the system. You will still be able to activate calibration buffs similar to before (without contributing to the cali train fund), just that you do not need to use items to do so, you can simply click on the interface to deploy individual cali buffs.

    ![image](https://github.com/DexterHuang/CyberCodeOnline/assets/18545294/f20c21c4-012b-4a3a-a5a5-54c4212a88ba)

  - Calibration UI update, mainly to streamline the process and make it more user-friendly and intuitive.
  - Improving SLANC's notice when the train is fully funded, it will include specific timestamps for each tier of calibration, **However please keep in mind, the server MAY NOT deploy them at the exact time due to technical reason, it will try to, but may be delayed**

- The Chat interface UI will receive an update mainly on reading old message indicator, reply indicator UI, and banner display

![image](https://github.com/DexterHuang/CyberCodeOnline/assets/18545294/0ffe0246-c81f-4109-8325-a58034003973)

- with suggestion from players, donator chat frame gallery page is added, allowing you to see all chat frames in game

![image](https://github.com/DexterHuang/CyberCodeOnline/assets/18545294/464d5352-a294-4126-b455-360d13fc0536)

- Some bug fixes regarding to pet system
- Updated cosmetic selection page, now shows previews of chat box to better represent the chat frame

![image](https://github.com/DexterHuang/CyberCodeOnline/assets/18545294/dc0b39ee-9ebf-4543-84b1-1c331ad6845d)

- Added new tutorial page for calibration tran, everyone is welcome to edit and add info on our github page
- Increased chance of Rare equipment and max amount of AI cores dropping from `Rare Locked Container`, other drops remain the same except for retired items being removed from the drop list, `Legendary Locked Container` was not changed besides retiring items

### 0.1838

- Security Update

### 0.1837

- Fixed display issue on rainbow chat frame

### 0.1836

- Fixed translation error in the Cali-train buff description, system will deploy in 40-minute intervals instead of wrongly stated 5 minutes. this does not impact the actual system code, just a translation error.
- Updated Victor (Trinoky Mart) image to align with the current art style
- Updated Lexi (Bank) image to align with the current art style

### 0.1835

- Fixed compatibility issue with devices uses older versions of webview
- Updated feedback survey UI

### 0.1834

- Added pet leaderboard, now shows players with oldest pets, only one of your pet can be on the leaderboard, and if your pet dies or is disposed, it will be automatically removed from the leaderboard, revived pet will return to leaderboard but while pet is dead, age will not increase

### 0.1833

- With player suggestions, Cali Train Community funding is added, similar to Party Funds, you can contribute 10% of the Cali Train Community funding with your unit, when the funding reaches 100%, Cali Train will activate in the next UTC 00:00 time, the system will deploy the first +1 calibration at that time, followed by 40 minutes cooldown and then the next one till +10, the buff deployed will consist of exactly the calibration chance needed and a safety buff for 5 minutes for each round.

![image](https://github.com/DexterHuang/CyberCodeOnline/assets/18545294/0df4d15b-9cc4-4c6c-830f-225f019b0cc8)

- Updated Kamiko, Violet, and Jen's image to align with current art style
- Updated chat UI to show current community goal status, skip count will show up only when a skip is in progress

### 0.1832

- Fixed minor UI issue

### 0.1831

- Added global party contribution feature, now you can go to `Partyline Pub` found in the market street, where a new NPC `Jieun` has been added, you can contribute 10% of global party with your unit, when the funding reaches 100%, global party buff will be activated immediately.
  - When the funds are collected, the global party buff will be activated immediately, and the buff will last for 24 hours, the buff is the same as the existing global party buff
  - If a global buff is already active when a player tries to contribute the last bit of the fund, the server will not allow contribution until the buff ends, however you can freely contribute the fund as long as its not the last bit of the fund.
  - If a normal global buff (the activated by item) is used, it WILL NOT affect the global party contribution progress, the progress will continue as normal, the progress only resets when the last bit of the fund is contributed and the buff is activated by the community.

![image](https://github.com/DexterHuang/CyberCodeOnline/assets/18545294/f1a41a2c-73cc-414b-a4f8-64eee9bd3b7c)

### 0.1830

- Fixed issue with chat message popup on non-English UI
- Fixed problem with Posh Exploit leaking to gang chat

### 0.1829

- Improved the look and feel of the new Netrunner cosmetic player detail page

![image](https://github.com/DexterHuang/CyberCodeOnline/assets/18545294/62f1ac7d-94e1-4a94-91a3-b10935032a98)

- Improved player chat message model UI (the pop when you click on the player's message), now shows the player's title colour, gang tag and emblem
- Fixed issue with playing with other player's pet.

### 0.1828

- Fixed issue with player name tag display
- Added Posh Chat Exploit, which transforms everyone into a fine British gentleman for 10 minutes
- Added new frame

### 0.1827

- Fixed issue with being able to purchase items when AFK task is running
- Fixed issue with unable to play with other player's pet

### 0.1826

- Now apartment market shows how many pet slots each type of apartment has
- Fix display issue related to the latest iOS system update

### 0.1825

- Gang leaderboard is graphic is overhauled, now it shows the gang's image motto and member count.
- Now `Jin` will sell `Volunteer Service Medallion`, this is to ensure that people with very bad luck can also obtain the item by exchanging it with `Paw Credit` which is obtainable from the `Pet Shelter Volunteer Shift AFK` activity.
- You can now recycle `Volunteer Service Medallion` using `Recycler` to get `Paw Credit`

**Note: Since this feature is still in very beta stage, the specific stats can change base on player feedback and balance needs**

- Fixed issue with viewing other player's pet

### 0.1824

### Pet & Apartment System (Initial Beta, please report any bugs or suggestions to the Discord server)

- You can adopt pets, The pet system is aimed towards a **Role-Play** element instead of adding combat/stat-related mechanics to avoid adding a traditional "Gacha" system which understandably many people want to avoid; instead, pets will adopt a more "Tamagotchi" style of gameplay (Tamagotchi is a type of simulation game where you take care of a virtual pet. very popular in the 90s), you will need to feed, play, and take care of your pet when they are sick to keep them happy and healthy.
- You will be able to check out other players' pets and you can tag your pet by mentioning them in chat to show it to other players, similar to how you mention other players. in the initial version of the pet system, you can play with other players' pets, but you cannot feed them or clean them, that will be the owner's responsibility.
- Taking care of your pet: Pets will have a hunger, happiness and cleanness meter, and a hidden healthiness meter, when the pet is too hungry, unhappy or dirty, it will correspondingly affect their mood, if you continue to neglect your pet, it will get sick and eventually die, you can take care of your pet by feeding them, playing with them, cleaning them and giving them medicine when they are sick.
- Obtaining pets: continuing the unique theme of CyberCode Online emphasis on no pay-to-win, the items required to redeem pets will be obtainable through `Pet Shelter Volunteer Shift AFK` activity and Global Buff similar to how Calibration currently works. by doing this task there will be a chance of receiving:
  - `Paw Credit`, You can use it to redeem pet-related items from the pet shelter
  - `Volunteer Service Medallion`, you combine 10 of these to get one `Sanctuary Adoption Pass` which you can use to adopt a pet when `Adoption Buff` is activated by any player.
- Pet types: it is planned to have two types of pets at the initial launch; cats and dogs, each type will have hundreds of different images based on breeds and colors, and the image of the pets will be determined randomly when you adopt the pet(more types of pets are expected to be added in the future, suggestions are welcomed). you can also randomly change the cosmetic image of your pet without changing the pet's data such as type, hunger, happiness, name and age by using Unit.
- what happens if your pet dies: if unfortunately your pet dies, you can adopt a new pet or you can choose to activate `Revival Buff` Global Buff to revive your pet and anyone who chooses to revive their pet during the buff duration. there will be cooldowns for reviving pets to ensure that one revival buff can only revive one pet per player.
- Apartments: You can rent apartments with BTC, and the rental fee is weekly based, if you don't have enough BTC in your account when the rental fee is due, you will be evicted from the apartment. there will be different tiers of apartments, each tier allows you to have bigger 'spaces' for your pet. currently apartment serves as a place that allows you to own pets (you must have an apartment to own a pet) and for future updates.
- Apartment restrictions: you can only have one apartment per account, and you must be at least level 100, as renting an apartment requires you to have some amount of excess BTC, this is to ensure that new players won't spend their hard-earned BTC on renting an apartment and then regret it later. at the same time encourages players to level up and serve as a progression milestone.
- Apartment on market: every day there will be random apartments available for rent on the market, with different appearances, addresses and price

### Other Changes:

- improve on auto-translation system, should produce better initial translation results
- Fixed display issue on emblems

  0.1823

- Added Spring Cherry Blossom event; all skips get 5% off during the event period, and added an exclusive sakura chat frame and emblem
- Minor UI updates
- Performance optimization on the server side

  0.1822

### Lunar New Year Event:

- During the event (Feb 1st to Feb 29th), enemies, the AFK bot farm will have a chance to drop a `Red Envelope` which you can open to get a random amount of `Gold Coin`
- You can use `Gold Coin` to purchase various items from `Yen's store`
- During the event period, you will receive various amounts of free `Rare Synaptic Acceleration Transmitter` when you top up Units based on the package selected. Added new Skipper-exclusive cosmetics
- Added new CyberDragon cosmetic
- Updated Luna's(Yen's Store) graphic
- Updated Zero's(Bald dude in the black market) graphic
- Updated market street background image

  0.1821

- Fixed issue with being able to start bulk crafting while being idle
- Fixed being able to tag, send gift or DM system placeholder account.

  0.1820

- Fixed issue with Christmas event item still dropping after the event ended
- Now auto-select feature on the selling to NPC page will not select locked items
- Added indication on dungeon lobby list to show if the dungeon is password-protected
- ASU is changed to untradable as announced previously

## Notice

With player feedback and discussion with players, we have postponed the change to `Autonomous Storage Unit`'s tradable status to untradable, instead, it is now tradable again.
and will be updated to not tradable on 01/01/2024 giving everyone plenty of time to arrange their ASU.

經過仔細聽取玩家的反饋和與玩家討論後, `Autonomous Storage Unit`(ASU) 已先改回可交易, 讓各位有時間安排 ASU 的處理方式,
ASU 會在明年 2024 年 1 月 1 號才更新為不可交易 給予大家充足的時間

Again, thank you for all the valuable feedback :)

再次感謝大家的寶貴意見與討論:)

0.1819

- Updated some images now on the equipment upgrade module selection menu, it should not show you modules you cannot use due to insufficient level and only show those you can use on the item.
- Updated leaderboard UI to include numbering so it is easier to know which rank you are in
- Fixed issue with translated text showing incorrectly in notifications and discord log
- Fixed EXP calculation on AFK exp boost, there was a bug where in some situations the bonus EXP was not calculated correctly
- Slight adjustment on the system message UI

  0.1818

- Christmas Event starts today, during December, enemies, scavenge and AFK farm bots will have a chance to drop ` Frosty Container`` and  `Christmas Pudding`
- You can open Frosty Container to get various rewards, including the chance of EPIC Cache and Tech Scrap Cluster
- You can consume Christmas Pudding to get a 20 minutes buff that gives you a +20% EXP gain from AFK tasks
- Added Christmas-themed cosmetics, including emblems and chat frames.
- Skip announcement now is translatable and a button to send street cred to the skipper is added.
- Added a new leaderboard for crafting epic equipment and ASU, all the counting will start from this update for fairness because there was no previous tracking for this.
- Updated the crafted epic equipment announcement to include item data, you will be able to click on the item name to view the item's details.
- Fixed issue with time desync on some devices, preventing AFK task time from showing correctly.
- Fixed when client time is incorrect, chat message can be sent from the client can show in an incorrect place (stuck at the bottom or show up in the middle of message less instead of the bottom)

  0.1817

- Updated rules to include examples for "no IRL trading", to better clarify that trading with virtual currencies such as Google Play Cards or other points from other services are examples of indirect trading IRL money. please see the actual rules for the details.
- Optimized SLANC's backend logic
- Now players who are muted or suspended cannot be tagged, to discourage the muted individuals motivated by attention from getting even more attention.
- Other various chat server fixes and optimizations

  0.1816

- Market place item, purchase item UI has been reworked to provide a more streamlined experience, no longer to fill up multiple popups and instead all in one page.

![image](https://github.com/DexterHuang/CyberCodeOnline/assets/18545294/20401be3-12b0-4dc2-aecc-1a33b0954c99)
![image](https://github.com/DexterHuang/CyberCodeOnline/assets/18545294/a3f1b601-3fca-4bdf-ac88-eb1408c12d8d)

- Rewrite of the captcha image generation system, now it is much more efficient faster, and more secure.
- Fixed server-side issues

  0.1815

- Updated leaderboard UI, making it clear which boards are game-play based which are contribution-based.
- Optimized leaderboard loading for all boards, allowing us to show 32 players per board instead of 16 previously for all boards

  0.1814

- Added skip point to the leaderboard
- Optimized leaderboard loading time, and changed the leaderboard to refresh every hour, to increase efficiency and increase speed
- Added translation support to leaderboard UI

  0.1813

- With many discussions and feedback from the community, the skip count statistic will be a point system where:
  - Every 15-minute skip is 1 point so that you can skip longer periods while still getting equivalent points.
  - Above 150 minutes is fixed to 10 points to encourage multiple skips rather than one huge skip to maximize the benefit for most players
- Additionally added skip discount, during this event, all skip above 105 minutes will receive 5% off until the end of the event.\
- UI update on AFK screen

  0.1812

- Added Thanksgiving event, during the event period, Scavenging and AFK farm bot will drop `Roasted Turkey` rarely.
  - Consuming Roasted Turkey gives your `AFK EXP Boost` effect for 20 minutes, during this status effect, AFK tasks completed will gain +20% EXP. Please note, the bonus EXP check is when you finish your AFK task not when the task started; so in order to receive the bonus EXP, please ensure that the buff is active when your AFK task finishes.
- Added skip count statistic to player profile, you can now see your and others' total skip count. **Because this is a new statistic previously not tracked, everyone's count will start from this update**
- Added skip-exclusive cosmetics, including emblems and chat frames, these can only be obtained by reaching specific skip counts.
- Various bug fixes
- Server stability fix
